import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { MQTTProvider } from 'amos-mqtt';
import { connectGlobalPage } from '@gm/graphmod-common';
import { commond } from '@gm/graphmod-mapsdk';
import { message, eventConsts } from './../eventConsts';
import dutyConfig from './config';
import SecurityPostureCustomHandle from './securityPosture';


const DutyMap = commond.DutyMap;
/**
 * 地图屏（战备值守和应急指挥）容器
 *
 * @class Map
 * @extends {Component}
 */
@connectGlobalPage({
  system: 'commmand', // 填写mapsdk 提供的公共地图业务系统名称
  testDataConfig: {
    mqttUrl: 'ws://172.16.10.85:8083/mqtt', // 消息地址
    mapUrl: 'http://172.16.11.20:3009/fire-fighting-system/mapsdk', // 地图地址
    tileServerUrl: 'http://172.16.3.120:8001/fulong' // 地图瓦片服务地址
  },
  testVisualParams: {
    theme: 'screen' // 填写mapsdk 提供的公共地图业务提供的主题名称
    // theme: 'blue' // 填写mapsdk 提供的公共地图业务提供的主题名称
  }
})
class Map extends Component {
  static propTypes = {
    dataConfig: PropTypes.object,
    visualParams: PropTypes.object
  };

  static defaultProps = {
    dataConfig: {},
    visualParams: {}
  };

  constructor(props) {
    super(props);
    this.alarmInfo = message.getStorageData(eventConsts.ALARM_INFO);
  }

  render() {
    const { dataConfig } = this.props;
    return (
      <MQTTProvider url={dataConfig.mqttUrl}>
        <div key="ccsmap" style={{ with: '100%', height: '100%' }}>
          <DutyMap
            ref={n=>this.dutyMap = n}
            key="securityposture"
            {...this.props}
            config={dutyConfig(this.alarmInfo)}
            mapsdkConfig={{
              tileServerUrl: dataConfig.tileServerUrl,
              offline: true
            }}
            globalData={{ 'stationCode': this.alarmInfo.stationCode, sourceId: this.alarmInfo.id }}
            customHandle={SecurityPostureCustomHandle}
          />
        </div>
      </MQTTProvider>
    );
  }
}

export default Map;
