import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { FlvPlay } from '@gm/graphmod-common';
import { Modal } from 'amos-framework';
/**
 * 地图上摄像头点弹框
 *
 * @class VideoModal
 * @extends {Component}
 */
class VideoModal extends Component {

  static propTypes = {
    onClose: PropTypes.func,
    visible: PropTypes.bool,
    data: PropTypes.object
  };

  static defaultProps = {

  };

  constructor(props) {
    super(props);
    this.state = {
      data: {}
    };
  }

  componentDidMount() {
    this.onInit();
  }

  componentDidUpdate(prevProps, prevState) {

  }

  onInit = () => {
    const { data } = this.props;
    this.setState({ data });
  }

  handleCancel = () => {
    this.setState({ data: {} });
    this.props.onClose();
  }

  render() {
    const { visible } = this.props;
    const { data } = this.state;
    return (
      <Modal
        header={data.name || '监控视屏'}
        className="ccs-modal"
        width={800}
        visible={visible}
        noDefaultFooter
        onCancel={this.handleCancel}
        content={
          <div className="ccs-map-vediocontent">
            { data.playUrl && <FlvPlay width="100%" height="100%" vedioId={`video${data.id}`} liveVideoHost={data.playUrl} /> }
          </div>
        }
      />
    );
  }
}

export default VideoModal;
