import React from 'react';
import PropTypes from 'prop-types';
import { commond } from '@gm/graphmod-mapsdk';
import VideoModal from './VideoModal';
import { message, eventConsts } from './../../eventConsts';
import './index.scss';

const EventConsts = commond.EventConsts;

class OperEvent extends commond.BasicCustom {
  constructor(props) {
    super(props);
  }

  /**
   * 值格式化展示
   * @returns
   */
  valueFormat = {

  }

  a1 =()=>{
    return <div />;
  }

  a2 =()=>{
    return <div />;
  }

  defaultOpenTitle=(e,data)=>{
    if (data && data.length > 0){
      // 默认打开顶牌
      const alarmData = {
        ...data[0],
        lng: data[0].sourceLng,
        lat: data[0].sourceLat
      };
      this.mapEvent.locationToPoint( alarmData, { id: '实时告警' });
    }
  }


  /**
   * 切换到告警点
   */
  switchToAlarmPoint = () => {
    const stationData = message.getStorageData(eventConsts.ALARM_INFO);
    const data = {
      ...stationData,
      lng: stationData.sourceLng,
      lat: stationData.sourceLat
    };
    this.mapEvent.setMapLevels([17, 19]);
    this.mapEvent.locationToPoint(data, { id: '实时告警' });
  }
  /**
   * 点击地图上的标记点
   * @param {MapPoint} data 地图点数据
  */
  onPointClick(data) {
    // 点击地图
    if (data.classify === '摄像头') {
      this.onOpen(<VideoModal data={data.data} visible />, EventConsts.AREA_MODAL);
    }
  }
  /**
   * 双击地图上的标记点
   * @param {MapPoint} data 地图点数据
  */
  onPointDoubleClick(data) {
    if (data.classify === '实时告警') {
      this.switchToAlarmPoint(data.data.stationCode);
    }
  }
}

OperEvent.propTypes = {
  onOpen: PropTypes.func,
  onClose: PropTypes.func
};

export default OperEvent;
