import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { BarChart } from 'amos-viz/lib/echarts';
import { ScreenCard, withSubscribeMQTT } from './../../common';
import {
  faultEquipmentTop10Action
} from './../api';

/**
 * 故障设备Top10
 * @class FaultyEquipment
 * @extends {Component}
 */
@withSubscribeMQTT({ topic: 'power' })
class FaultyEquipment extends Component {
  constructor(props) {
    super(props);
    this.state = {
      xData: [],
      yData: []
    };
  }

  componentDidMount() {
    this.onRequest();
  }

  componentDidUpdate(prevProps, prevState) {
    if (this.props.messageFlag !== prevProps.messageFlag) {
      this.onRequest();
    }
  }

  onRequest = () => {
    faultEquipmentTop10Action().then(d => {
      let xData = [];
      let yData = [];
      if (d) {
        d.forEach(item => {
          xData.push(item.total ? item.total : 0);
          yData.push(item.name ? item.name : '');
        });
      }
      this.setState({ xData, yData });
    });
  }

  textStytle = (value) => {
    // eslint-disable-next-line no-magic-numbers
    if (value.length > 3) {
      // eslint-disable-next-line no-magic-numbers
      return `${value.substring(0, 3)}...`;
    } else {
      return value;
    }
  }

  getPieOption = () => {
    const { xData, yData } = this.state;
    return {
      grid: {
        x: 60,
        y: 40,
        x2: 50,
        y2: 50,
        borderWidth: 5,
        tooltip: {
          trigger: 'axis'
        }
      },
      xAxis: {
        type: 'value',
        axisLabel: {
          show: false
        },
        splitLine: {
          show: false
        },
        axisLine: {
          show: false
        },
        axisTick: {
          show: false
        }
      },
      yAxis: {
        inverse: true,
        axisLine: {
          show: false
        },
        type: 'category',
        data: yData,
        axisLabel: {
          margin: 10,
          color: '#fff',
          fontSize: 12,
          formatter: value =>  this.textStytle(value)
        },
        splitLine: {
          show: false
        },
        axisTick: {
          show: false,
          alignWithLabel: true
        }
      },
      tooltip: {},
      series: [{
        name: '数目',
        data: xData,
        type: 'bar',
        itemStyle: {
          normal: {
            color: {
              type: 'linear',
              x: 0,
              y: 0,
              x2: 1,
              y2: 1,
              colorStops: [
                {
                  offset: 0,
                  color: '#22F7FF'
                },
                {
                  offset: 1,
                  color: '#1191DB'
                }
              ],
              global: false
            },
            // color: ['#3977E6', '#37BBF8'],
            barBorderRadius: 7
          },
          emphasis: {
            barBorderRadius: 7
          }
        },
        barWidth: 10,
        showBackground: true,
        legendHoverLink: true,
        label: {
          normal: {
            show: true,
            position: 'right',
            distance: 5,
            align: 'left',
            formatter: '{c}',
            color: 'white'
          }
        }
      }]
    };
  }

  render() {
    return (
      <ScreenCard title="故障设备Top10">
        <div className="ccs-iot-monitoring-left-chart">
          <BarChart
            option={this.getPieOption()}
          />
        </div>
      </ScreenCard>
    );
  }
}

FaultyEquipment.propTypes = {
  messageFlag: PropTypes.number
};

export default FaultyEquipment;
