import React, { Component } from 'react';
// import PropTypes from 'prop-types';
import Item from './item';
import {
  alarmCountAction
} from './../api';

class AlarmDangerStatistics extends Component {
  constructor(props) {
    super(props);
    this.state = {
      alertCalled: []
    };
  }

  componentDidMount() {
    this.onRequest();
  }

  onRequest = () => {
    alarmCountAction().then(d => {
      let data = [];
      if (d) {
        data = [
          {
            title: '今日告警数量',
            label: '今日告警数量',
            value: d.todayAlarmTimes ? d.todayAlarmTimes : 0
          },
          {
            title: '昨日告警数量',
            label: '昨日告警数量',
            value: d.yesterdayAlarmTimes ? d.yesterdayAlarmTimes : 0
          },
          {
            title: '本周告警数量',
            label: '本周告警数量',
            value: d.weekAlarmTimes ? d.weekAlarmTimes : 0
          },
          {
            title: '本月告警数量',
            label: '本月告警数量',
            value: d.monthAlarmTimes ? d.monthAlarmTimes : 0
          }
        ];
      }
      this.setState({ alertCalled: data || [] });
    });
  }


  render() {
    const { alertCalled = [] } = this.state;
    return (
      <div className="ccs-on-iot-monitoring-statistics" style={{ height: '94%' }} >
        <div className="ccs-on-iot-monitoring-statistics-head"> <span>警情信息</span></div>
        <div className="ccs-on-iot-monitoring-statistics-content">
          {
            alertCalled.map(m => <Item key={m.title} title={m.label} total={m.value} />)
          }
        </div>

      </div>
    );
  }
}

export default AlarmDangerStatistics;
