import React, { Component } from 'react';
import { connectGlobalPage } from '@gm/graphmod-common';
import { message, eventConsts } from './../eventConsts';
import DisposalContent from './Disposal';
import './index.scss';

/**
 * 处置对象
 *
 * @class Disposal
 * @extends {Component}
 */
@connectGlobalPage({})
class Disposal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      alarm: message.getStorageData(eventConsts.FIRE_ACTIVE_CAHNGE) || {}
    };
  }

  componentDidMount() {
    message.on(eventConsts.FIRE_ACTIVE_CAHNGE, (data) => {
      this.setState({ alarm: data || {} });
    }, true, true);
  }

  render() {
    const { alarm = {} } = this.state;
    return (
      <DisposalContent key={alarm.sequenceNbr} alarm={alarm} {...this.props} />
    );
  }
}

export default Disposal;
