import { request, gateWay } from '@gm/graphmod-utils';

const {
  commonGet,
  formatUrl,
  completePrefix
} = request;

export const UrlConsts = {
  getEquipmentByMridUrl: () => completePrefix()(gateWay.ccs, 'equipment/{mrid}/info'), 
  getBuildingByMridUrl: () => completePrefix()(gateWay.ccs, 'fire-building/{mrid}/info') 
};

/**
 * 根据电力设备mrid查询电力设备详情
 * @param {*} mrid 
 */
export const getEquipmentByMridAction = (mrid) => {
  return commonGet(formatUrl(UrlConsts.getEquipmentByMridUrl(), { mrid }));
};

/**
 * 根据建筑mrid查询建筑详情
 * @param {*} mrid 
 */
export const getBuildingByMridAction = (mrid) => {
  return commonGet(formatUrl(UrlConsts.getBuildingByMridUrl(), { mrid }));
};
