import React, { Component } from 'react';
import { getPropsValue } from 'amos-designer';
import { Tabs } from 'amos-framework';
import { getBuildingByMridAction }  from './../api';
import { message, eventConsts } from './../../eventConsts';
import Picture from './../components/Picture';
import { IconTitle, LabelValueFrame } from './../../common';
import { pageInfo } from './../mockdata'

const { TabList, Tab, TabPanel } = Tabs;

/**
 * 救援对象 - 所属建筑
 *
 * @class RescueObject
 * @extends {Component}
 */
class BuildObject extends Component {
  constructor(props) {
    super(props);
    this.state = {
      alarm: message.getStorageData(eventConsts.FIRE_ALARM_CHANGE) || { fireBuildingMrid: '13010201' },
      data: {}
    };
  }

  componentDidMount() {
    this.onRequest();
    message.on(eventConsts.FIRE_ALARM_CHANGE, (data) => {
      this.setState({ alarm: data || {} });
    }, false, true);
    this.onRequest();
  }

  onRequest = () => {
    const { alarm = {} } = this.state;
    getBuildingByMridAction(alarm.fireBuildingMrid).then(d => this.setState({ data: d || {} }));
  }

  renderBasic = () => {
    return [
      { label: '所属区域', value: 'area', labelWidth: '10em', width: '100%' },
      { label: '建（构）筑名称', value: 'name', labelWidth: '10em', width: '100%' },
      { label: '建（构）筑编号', value: 'code', labelWidth: '10em', width: '100%' },
      { label: '建（构）筑类别', value: 'buildType', labelWidth: '10em', width: '100%' },
      { label: '建筑位置', value: 'address', labelWidth: '10em', width: '100%' },
      { label: '建造日期', value: 'buildDate', labelWidth: '10em', width: '100%' },
      { label: '结构类型', value: 'structureType', labelWidth: '10em', width: '100%' },
      { label: '火灾危险性', value: 'fireRisk', labelWidth: '10em', width: '100%' },
      { label: '耐火等级', value: 'fireResistanceLevel', labelWidth: '10em', width: '100%' },
      { label: '建筑高度', value: 'height', labelWidth: '10em', width: '100%' },
      { label: '建筑层数', value: 'floorNumber', labelWidth: '10em', width: '100%' },
      { label: '占地面积', value: 'floorArea', labelWidth: '10em', width: '100%' },
      { label: '房间数量', value: 'roomNumber', labelWidth: '10em', width: '100%' },
      { label: '责任人', value: 'dutyUser', labelWidth: '10em', width: '100%' },
      { label: '责任人电话', value: 'dutyUserPhone', labelWidth: '10em', width: '100%' }
    ];
  }

  render() {
    const { data } = this.state;
    return (
      <div className="ccs-box ccs-scrollbar">
        <div className="ccs-left-box">
          <IconTitle title={getPropsValue(data, 'orgUsrzhDto.bizOrgName', '')} />
          <LabelValueFrame columns={this.renderBasic()} data={data} />
        </div>
        <div className="ccs-right-box">
          <Tabs mode="line">
            <TabList>
              <Tab>建筑图片</Tab>
              <Tab>消防通道布置图</Tab>
              <Tab>建筑立面图</Tab>
              <Tab>建筑平面图</Tab>
            </TabList>
            <TabPanel>
              <Picture
                imgArr={data.img || []}
                length={(data.img || []).length}
              />
            </TabPanel>
            <TabPanel>
              <Picture
                imgArr={data.fireExitsImg || []}
                length={(data.fireExitsImg || []).length}
              />
            </TabPanel>
            <TabPanel>
              <Picture
                imgArr={data.elevationImg || []}
                length={(data.elevationImg || []).length}
              />
            </TabPanel>
            <TabPanel>
              <Picture
                imgArr={data.planarGraphImg || []}
                length={(data.planarGraphImg || []).length}
              />
            </TabPanel>
          </Tabs>
        </div>
      </div>
    );

  }
}

export default BuildObject;
