import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Carousel } from 'amos-framework';
import '../index.scss';

/**
 * 图片
 *
 * @class Picture
 * @extends {Component}
 */
class Picture extends Component {
    static propTypes = {
      imgArr: PropTypes.array,
      length: PropTypes.number
    };

    constructor(props) {
      super(props);
      this.state = {
        activeIndex: 0,
        activeIndexAfter: 0
      };
    }

    componentDidMount() {
    }

  beforeChange = (current, next) => {
    this.setState({ activeIndex: next });
  }

  afterChange = (current) => {
    this.setState({ activeIndexAfter: current });
  }
  render() {
    const props = {
      dots: true,
      infinite: true,
      speed: 1000,
      arrows: true,
      slidesToShow: 1,
      slidesToScroll: 1,
      beforeChange: this.beforeChange,
      afterChange: this.afterChange
    };
    const { imgArr,length } = this.props;
    return <div className="ccs-box">
      {console.log(imgArr,'imgArr')}
      {
        imgArr.length > 0 ?
          <div style={{ width: '100%' }}>
            <div style={{ color: 'white', height: '34vw' }}>
              <Carousel {...props}>
                {
                  imgArr.map((item) =>{
                    return  <div key={1} className="ccs-content-item">
                      <img  alt="" src={item} className="ccs-img"/>
                    </div>;

                  })
                }
              </Carousel>
            </div>
            <div className="ccs-total">
              第{Number(this.state.activeIndex) + 1}/{length}张
            </div>
          </div>
          :
          <div style={{ color: 'white',textAlign: 'center',width: '100%' }}>暂无数据</div>
      }

    </div>;
  }
}

export default Picture;
