import React, { Component } from 'react';
import { getPropsValue } from 'amos-designer';
import { Tabs } from 'amos-framework';
import { getEquipmentByMridAction }  from './../api';
import { message, eventConsts } from './../../eventConsts';
import Picture from './../components/Picture';
import { IconTitle, LabelValueFrame } from './../../common';
import { pageInfo } from './../mockdata'

const { TabList, Tab, TabPanel } = Tabs;

/**
 * 救援对象 - 单位
 *
 * @class RescueObject
 * @extends {Component}
 */
class RescueObject extends Component {
  constructor(props) {
    super(props);
    this.state = {
      alarm: message.getStorageData(eventConsts.FIRE_ALARM_CHANGE) || { protectedObjectMrid: '011023306003990000000878' },
      data: {}
    };
  }

  componentDidMount() {
    message.on(eventConsts.FIRE_ALARM_CHANGE, (data) => {
      this.setState({ alarm: data || {} });
    }, false, true);
    this.onRequest();
  }

  onRequest = () => {
    const { alarm = {} } = this.state;
    getEquipmentByMridAction(alarm.protectedObjectMrid).then(d => this.setState({ data: d || {} }));
  }

  renderBasic = () => {
    return [
      { label: '站点名称', value: 'stationName', labelWidth: '10em', width: '100%' },
      { label: '站点编码', value: 'stationCode', labelWidth: '10em', width: '100%' },
      { label: '电力设备名称', value: 'name', labelWidth: '10em', width: '100%' },
      { label: '电力设备编码', value: 'mrid', labelWidth: '10em', width: '100%' },
      { label: '所属区域名称', value: 'workArea', labelWidth: '10em', width: '100%' },
      { label: '所属建（构）筑名称', value: 'buildName', labelWidth: '10em', width: '100%' },
      { label: '所属房间名称', value: 'roomName', labelWidth: '10em', width: '100%' },
      { label: '详细位置', value: 'address', labelWidth: '10em', width: '100%' },
      { label: '责任部门', value: 'chargeDept', labelWidth: '10em', width: '100%' },
      { label: '责任人', value: 'chargeUser', labelWidth: '10em', width: '100%' }
    ];
  }

  render() {
    const { data } = this.state;
    return (
      <div className="ccs-box ccs-scrollbar">
        <div className="ccs-left-box">
          <IconTitle title={getPropsValue(data, 'orgUsrzhDto.bizOrgName', '')} />
          <LabelValueFrame columns={this.renderBasic()} data={data} />
        </div>
        <div className="ccs-right-box">
          <Tabs mode="line">
            <TabList>
              <Tab>电源负荷图</Tab>
              <Tab>电缆沟封堵图</Tab>
              <Tab>消防车进站行车路线图</Tab>
              <Tab>消防取水图</Tab>
              <Tab>设备图</Tab>
            </TabList>
            <TabPanel>
              <Picture
                imgArr={data.powerImg || []}
                length={(data.powerImg || []).length}
              />
            </TabPanel>
            <TabPanel>
              <Picture
                imgArr={data.pluggingImg || []}
                length={(data.pluggingImg || []).length}
              />
            </TabPanel>
            <TabPanel>
              <Picture
                imgArr={data.routeImg || []}
                length={(data.routeImg || []).length}
              />
            </TabPanel>
            <TabPanel>
              <Picture
                imgArr={data.fetchWaterImg || []}
                length={(data.fetchWaterImg || []).length}
              />
            </TabPanel>
            <TabPanel>
              <Picture
                imgArr={data.img || []}
                length={(data.img || []).length}
              />
            </TabPanel>
          </Tabs>
        </div>
      </div>
    );

  }
}

export default RescueObject;
