import React, { Component } from 'react';
import AmosEcharts from 'amos-viz/lib/echarts';
import { message, eventConsts } from './../../../eventConsts';
import {
  getRiskRiseUprateAction
} from './../../api';

class RpnPieChart extends Component {
  constructor(props) {
    super(props);
    this.state = {
      monthData: { type0Rate: '0%', countOfType0: 0 },
      seasonData: { type0Rate: '0%', countOfType0: 0 },
      yearData: { type0Rate: '0%', countOfType0: 0 },
      code: (message.getStorageData(eventConsts.STATION_CODE) || {}).message
    };
  }

  componentDidMount() {
    message.storageSubscribe(eventConsts.STATION_CODE, (data) => {
      console.log('rpn底部饼图');
      console.log(data);
      this.setState({
        code: data.message || '',
        monthData: { type0Rate: '0%', countOfType0: 0 },
        seasonData: { type0Rate: '0%', countOfType0: 0 },
        yearData: { type0Rate: '0%', countOfType0: 0 }
      }, this.onRequest);
    });
    this.onRequest();
  }

  onRequest = () => {
    // const code = '101';
    const { code } = this.state;
    getRiskRiseUprateAction(code).then(data => {
      let { monthData, seasonData, yearData } = this.state;
      monthData = data.month;
      seasonData = data.season;
      yearData = data.year;
      this.setState({
        monthData,
        seasonData,
        yearData
      });
    });
  }

  getOptions = (value, obj) => {
    let data = [];
    let color = '#54DBFF';
    let data1 = {};
    let data2 = {};
    if (obj) {
      if (value === 'month') {
        data1.name = `${obj.type0Rate}\r\n 本月风险\r\n上升率`;
        color = '#D32029';
      } else if (value === 'season') {
        data1.name = `${obj.type0Rate}\r\n本季度风险\r\n上升率`;
        color = '#D87A16';
      } else if (value === 'year') {
        data1.name = `${obj.type0Rate}\r\n本年风险\r\n上升率`;
        color = '#E8D639';
      }
      data1.value = obj.countOfType0;
      data2.value = obj.countOfSource - obj.countOfType0;
      data2.name = '';
      data.push(data1);
      data.push(data2);
    }
    let colors = [];
    colors.push(color);
    colors.push('#54DBFF');
    return {
      color: colors,
      series: [
        {
          name: '风险率',
          type: 'pie',
          radius: ['50%', '70%'],
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: true,
              color: '#fff',
              position: 'center',
              formatter: '{b}'
            }
          },
          labelLine: {
            normal: {
              show: false
            }
          },
          data
        }
      ]
    };
  }

  render() {
    const { monthData, seasonData, yearData } = this.state;
    let monthOption = this.getOptions('month', monthData);
    let seasonOption = this.getOptions('season', seasonData);
    let yearOption = this.getOptions('year', yearData);
    return (
      <div className="ccs-risk-situation-left-chart">
        <div className="ccs-risk-situation-left-chart-pie">

          <AmosEcharts option={monthOption} />
          <div className="ccs-risk-situation-left-chart-pie-value">
            <div className="ccs-risk-situation-left-chart-pie-value-right">
              <p className="ccs-risk-situation-left-chart-pie-value-right-p1">{monthData.countOfType0}</p>
              <p className="ccs-risk-situation-left-chart-pie-value-right-p2">{monthData.type0Rate}↑</p>
            </div>
            <p className="ccs-risk-situation-left-chart-pie-value-right-p3">本月风险</p>
          </div>
        </div>
        <div className="ccs-risk-situation-left-chart-pie">
          <AmosEcharts option={seasonOption} />
          <div className="ccs-risk-situation-left-chart-pie-value">
            <div className="ccs-risk-situation-left-chart-pie-value-right">
              <p className="ccs-risk-situation-left-chart-pie-value-right-p1">{seasonData.countOfType0}</p>
              <p className="ccs-risk-situation-left-chart-pie-value-right-p2">{seasonData.type0Rate}↑</p>
            </div>
            <p className="ccs-risk-situation-left-chart-pie-value-right-p3">本季度风险</p>
          </div>
        </div>
        <div className="ccs-risk-situation-left-chart-pie">
          <AmosEcharts option={yearOption} />
          <div className="ccs-risk-situation-left-chart-pie-value">
            <div className="ccs-risk-situation-left-chart-pie-value-right">
              <p className="ccs-risk-situation-left-chart-pie-value-right-p1">{yearData.countOfType0}</p>
              <p className="ccs-risk-situation-left-chart-pie-value-right-p2">{yearData.type0Rate}↑</p>
            </div>
            <p className="ccs-risk-situation-left-chart-pie-value-right-p3">本年风险</p>
          </div>
        </div>
      </div>
    );
  }
}

export default RpnPieChart;
