import React, { Component } from 'react';
import { LabelValue } from 'amos-designer';
import { deepCopy } from 'amos-tool';
import { ScreenCard, withSubscribeMQTT } from './../../common';
import { stationInfo } from './../config';
import { message, eventConsts } from './../../eventConsts';
import {
  getStationInfoAction
} from './../api';

/**
 * 换流站基本信息
 * @class BasicInfo
 * @extends {Component}
 */
@withSubscribeMQTT({ topic: 'alertNotice' })
class BasicInfo extends Component {
  static propTypes = {

  }

  constructor(props) {
    super(props);
    this.state = {
      infoList: stationInfo,
      info: {},
      code: (message.getStorageData(eventConsts.STATION_CODE) || {}).message
    };
  }

  componentDidMount() {
    message.storageSubscribe(eventConsts.STATION_CODE, (data) => {
      console.log('基础信息');
      console.log(data);
      this.setState({
        code: data.message || ''
      },() => this.onRequest());
    });
    this.onRequest();
  }

  onRequest = () => {
    // const code = '101';
    const { code } = this.state;
    getStationInfoAction(code).then(d => {
      const data = deepCopy(stationInfo);
      data.forEach(item => {
        item.value = d[item.key] ? d[item.key] : '';
      });
      this.setState({
        infoList: data,
        info: d
      });
    });

  }

  render() {
    const { info, infoList } = this.state;
    return (
      <ScreenCard title={info.name || '换流站'} className="ccs-disaster-dynamicinfo-details">
        {
          (infoList || []).map(e => (
            <LabelValue className="ccs-labelvalue" key={e.key} width="100%" labelWidth="7.8em" label={e.label} value={e.value} />
          ))
        }
      </ScreenCard>
    );
  }
}

export default BasicInfo;
