import { request, gateWay } from '@gm/graphmod-utils';

const {
  commonGet,
  formatUrl,
  completePrefix
} = request;

export const UrlConsts = {
  todaySecurityRankingUrl: () => completePrefix()(gateWay.ccs, 'fire-station-info/list?orderBy={orderBy}'), // 今日安全指数排名
  alarmDangerUrl: () => completePrefix()(gateWay.ccs, 'statistics/alarmAndDangerNumCount'), // 告警隐患信息统计
  alarmDanger30DaysUrl: () => completePrefix()(gateWay.ccs, 'statistics/alarmAndDangerTrend?beginDate={beginDate}&endDate={endDate}'), // 近30日告警隐患
  alarmDangerListUrl: () => completePrefix()(gateWay.ccs, 'fire-station-info/list?orderBy={orderBy}'), // 告警隐患列表
  newestDanger50Url: () => completePrefix()(gateWay.ccs, 'fire-latent-danger/list?top={top}'), // 隐患列表前50
  dangerGroupUrl: () => completePrefix()(gateWay.ccs, 'fire-latent-danger/state/group') // 隐患统计分组
};

/**
 * 告警隐患信息统计
 * @returns
 */
export function alarmDangerAction() {
  return commonGet(formatUrl(UrlConsts.alarmDangerUrl()));
}

/**
 * 今日安全指数排名
 * @returns
 */
export const todaySecurityRankingAction = (orderBy) => {
  return commonGet(formatUrl(UrlConsts.todaySecurityRankingUrl(), { orderBy }));
};

/**
 * 近30日告警隐患
 * @returns
 */
export const alarmDanger30DaysAction = (beginDate, endDate) => {
  return commonGet(formatUrl(UrlConsts.alarmDanger30DaysUrl(), { beginDate, endDate }));
};

/**
 * 告警隐患列表
 * @returns
 */
export const alarmDangerListAction = (orderBy) => {
  return commonGet(formatUrl(UrlConsts.alarmDangerListUrl(), { orderBy }));
};

/**
 * 隐患列表前50条
 * @returns
 */
export const newestDanger50Action = (top) => {
  return commonGet(formatUrl(UrlConsts.newestDanger50Url(), { top }));
};

/**
 * 隐患统计分组
 * @returns
 */
export const dangerGroupAction = () => {
  return commonGet(formatUrl(UrlConsts.dangerGroupUrl()));
};
