import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connectGlobalPage } from '@gm/graphmod-common';
import { MQTTProvider } from 'amos-mqtt';
import DangerStatistics from './side/DangerStatistics';
import TodaySecurityRanking from './side/TodaySecurityRanking';
import AlarmDangerList from './side/AlarmDangerList';
import NewestDanger from './side/NewestDanger';
import OnDutyDynamicMap from './map';
import './index.scss';

/**
 * 安全态势
 *
 * @class Content
 * @extends {Component}
 */
@connectGlobalPage({
  testDataConfig: {
    mqttUrl: 'ws://172.16.10.85:8083/mqtt' // 消息地址
  },
  testVisualParams: {
    theme: ''
  }
})
class Content extends Component {
  static propTypes = {
    dataConfig: PropTypes.object
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  render() {
    const { dataConfig = {} } = this.props;
    return (
      <MQTTProvider url={dataConfig.mqttUrl}>
        <div className="ccs-duty-dynamic on-duty-dynamic">
          <div className="ccs-duty-dynamic-side">
            <div className="ccs-duty-dynamic-left">
              <TodaySecurityRanking />
              <AlarmDangerList />
            </div>
          </div>
          <div className="ccs-duty-dynamic-content">
            <OnDutyDynamicMap />
          </div>
          <div className="ccs-duty-dynamic-side">
            <div className="ccs-duty-dynamic-right">
              <DangerStatistics />
              <NewestDanger />
            </div>
          </div>
        </div>
      </MQTTProvider>
    );
  }
}

export default Content;
