import React, { Component } from 'react';
import { BarChart } from 'amos-viz/lib/echarts';
// import PropTypes from 'prop-types';

import {
  alarmDangerListAction
} from './../api';

class DangerBarChart extends Component {
  constructor(props) {
    super(props);
    this.state = {
      xData: [],
      yData: []
    };
  }

  componentDidMount() {
    this.onRequest();
  }

  onRequest = () => {
    alarmDangerListAction(2).then(d => {
      let xData = [];
      let yData = [];
      if (d) {
        d.forEach(item => {
          xData.push(item.name);
          yData.push(item.existDangerNumber);
        });
      }
      this.setState({
        xData,
        yData
      });
    });
  }

  getPieOption = () => {
    const { xData, yData } = this.state;
    return {
      grid: {
        x: 50,
        y: 40,
        x2: 50,
        y2: 70,
        borderWidth: 5,
        tooltip: {
          trigger: 'axis'
        }
      },
      legend: {
        data: ['现有隐患'],
        bottom: '88%',
        textStyle: {
          color: '#fff'
        }
      },
      xAxis: {
        name: '换流站',
        type: 'category',
        data: xData,
        axisPointer: {
          type: 'shadow'
        },
        axisLabel: {
          margin: 10,
          color: '#fff',
          fontSize: 12,
          rotate: -30
        },
        axisLine: {
          lineStyle: {
            color: '#fff'
          }
        },
        axisTick: {
          alignWithLabel: true,
          color: '#fff',
          lineStyle: {
            color: '#fff'
          }
        }
      },
      yAxis: {
        name: '数目',
        type: 'value',
        axisLabel: {
          margin: 10,
          color: '#fff',
          fontSize: 16
        },
        axisLine: {
          lineStyle: {
            color: '#fff'
          }
        },
        splitLine: {
          show: true,
          lineStyle: {
            type: 'dashed'
          }
        }
      },
      tooltip: {},
      series: [{
        name: '现有隐患',
        data: yData,
        type: 'bar',
        label: {
          normal: {
            show: false,
            position: 'top',
            textStyle: {
              color: '#fff',
              fontSize: '10px'
            }
          }
        },
        itemStyle: {
          normal: {
            color: {
              type: 'linear',
              x: 0,
              y: 0,
              x2: 1,
              y2: 1,
              colorStops: [
                {
                  offset: 0,
                  color: '#EE6328'
                },
                {
                  offset: 1,
                  color: '#FD7D47'
                }
              ],
              global: false
            },
            barBorderRadius: 6
          },
          emphasis: {
            barBorderRadius: 6
          }
        },
        barWidth: 15,
        showBackground: true,
        legendHoverLink: true
      }]
      // ,
      // dataZoom: [{
      //   type: 'slider',
      //   show: true,
      //   start: 0,
      //   end: 45,
      //   handleSize: 8,
      //   dataBackground: {
      //     lineStyle: {
      //       color: 'rgba(225, 87, 19, 1)',
      //       shadowBlur: 1
      //     }
      //   },
      //   textStyle: {
      //     color: '#fff'
      //   }
      // }
      // ]
    };
  }

  render() {
    return (
      <div className="ccs-on-duty-dynamic-statistics" style={{ height: '100%' }} >
        <div className="ccs-on-duty-dynamic-statistics-head"> <span>换流站现有隐患</span></div>
        {
          // <div className="ccs-com-screencard-header">
          //   <span>换流站现有隐患</span>
          // </div>
        }
        <div className="ccs-on-duty-dynamic-statistics-chart">
          <BarChart
            option={this.getPieOption()}
          />
        </div>
      </div>
    );
  }
}

export default DangerBarChart;
