import React, { Component } from 'react';
import { LineChart } from 'amos-viz/lib/echarts';
import momentDateUtil from '../../common/utils/momentDateUtil';
// import PropTypes from 'prop-types';
import {
  alarmDanger30DaysAction
} from './../api';

class DangerLineChart extends Component {
  constructor(props) {
    super(props);
    this.state = {
      dayList: [], // 前端生成最近一个月日期 x轴
      yData: []
    };
  }

  componentDidMount() {
    this.onRequest();
  }

  onRequest = () => {
    // 获取最近一月的开始时间结束时间
    const { beginDate, endDate } = momentDateUtil.getLast30Days();
    const dayList = momentDateUtil.enumerateDaysBetweenDates(beginDate, endDate);
    let yData = [];
    alarmDanger30DaysAction(beginDate, endDate).then(d => {
      if (d) {
        yData = [
          {
            name: '告警数目',
            data: d.alarmTrend ? d.alarmTrend : [],
            type: 'line',
            smooth: true
          },
          {
            name: '新增隐患',
            data: d.dangerTrend ? d.dangerTrend : [],
            type: 'line',
            smooth: true
          }
        ];
        this.setState({ yData });
      }
    });
    this.setState({
      dayList
    });
  }

  getPieOption = () => {
    const { dayList, yData } = this.state;
    return {
      color: ['yellow', 'red'],
      grid: {
        x: 50,
        y: 40,
        x2: 50,
        y2: 40,
        borderWidth: 5
      },
      tooltip: {
        trigger: 'axis'
      },
      legend: {
        data: ['告警数目', '新增隐患'],
        bottom: '88%',
        textStyle: {
          color: '#fff'
        }
      },
      xAxis: {
        name: '日期',
        type: 'category',
        boundaryGap: false,
        data: dayList,
        axisPointer: {
          type: 'line'
        },
        axisLabel: {
          margin: 10,
          color: '#fff',
          fontSize: 12,
          rotate: -30
        },
        axisLine: {
          lineStyle: {
            color: '#fff'
          }
        },
        axisTick: {
          alignWithLabel: true,
          color: '#fff',
          lineStyle: {
            color: '#fff'
          }
        }
      },
      yAxis: {
        name: '数目',
        type: 'value',
        axisLabel: {
          margin: 10,
          color: '#fff',
          fontSize: 16
        },
        axisLine: {
          lineStyle: {
            color: '#fff'
          }
        },
        splitLine: {
          show: true,
          lineStyle: {
            type: 'dashed'
          }
        }
      },
      series: yData
    };
  }


  render() {
    return (
      <div className="ccs-on-duty-dynamic-statistics" style={{ height: '94%' }} >
        <div className="ccs-on-duty-dynamic-statistics-head"> <span>近一月告警隐患趋势</span></div>
        <div className="ccs-on-duty-dynamic-statistics-chart">
          <LineChart
            option={this.getPieOption()}
          />
        </div>
      </div>
    );
  }
}

export default DangerLineChart;
