import React, { Component } from 'react';
import { ScreenCard, withSubscribeMQTT } from './../../common';
// import { DangerStateEnum } from './../config';
import {
  dangerGroupAction
} from './../api';

/**
 * 隐患统计
 *
 * @class DangerStatistics
 * @extends {Component}
 */
@withSubscribeMQTT({ topic: 'alertNotice' })
class DangerStatistics extends Component {
  static propTypes = {

  }

  constructor(props) {
    super(props);
    this.state = {
      dangerStatisticsData: {}
    };
  }

  componentDidMount() {
    this.onRequest();
  }

  onRequest = () => {
    dangerGroupAction().then(d => {
      // let data = [];
      // if (d) {
      //   // Object.keys(d).forEach(key => {
      //   //   DangerStateEnum.getValues().forEach(item => {
      //   //     if (key === item.value) {
      //   //       data.push(item);
      //   //     }
      //   //   });
      //   // });
      // }
      this.setState({ dangerStatisticsData: d || {} });
    });
  }

  render() {
    const { dangerStatisticsData } = this.state;
    return (
      <ScreenCard title="换流站隐患统计">
        <div className="ccs-disaster-firesitesttistics-content">
          <div className="ccs-disaster-firesitesttistics-item">
            <div className="ccs-disaster-firesitesttistics-item-name">
              <img src="upload/sfcc/common/image/待评审.png" alt="" />
            </div>
            <div className="ccs-disaster-firesitesttistics-item-value">
              <p style={{ color: '#0FEBFF', fontWeight: 600 }}>{dangerStatisticsData[1] || ''}</p>
              <p>待评审</p>
            </div>
          </div>
          <div className="ccs-disaster-firesitesttistics-item">
            <div className="ccs-disaster-firesitesttistics-item-name">
              <img src="upload/sfcc/common/image/待治理.png" alt="" />
            </div>
            <div className="ccs-disaster-firesitesttistics-item-value">
              <p style={{ color: '#ffbf0f', fontWeight: 600 }}>{dangerStatisticsData[2] || ''}</p>
              <p>待治理</p>
            </div>
          </div>
        </div>
        <div className="ccs-disaster-firesitesttistics-content">
          <div className="ccs-disaster-firesitesttistics-item">
            <div className="ccs-disaster-firesitesttistics-item-name">
              <img src="upload/sfcc/common/image/待验证.png" alt="" />
            </div>
            <div className="ccs-disaster-firesitesttistics-item-value">
              <p style={{ color: '#0FEBFF', fontWeight: 600 }}>{dangerStatisticsData[4] || ''}</p>
              <p>待验证</p>
            </div>
          </div>
          <div className="ccs-disaster-firesitesttistics-item">
            <div className="ccs-disaster-firesitesttistics-item-name">
              <img src="upload/sfcc/common/image/延期中.png" alt="" />
            </div>
            <div className="ccs-disaster-firesitesttistics-item-value">
              <p style={{ color: '#ffbf0f', fontWeight: 600 }}>{dangerStatisticsData[7] || ''}</p>
              <p>延期中</p>
            </div>
          </div>
        </div>
        <div className="ccs-disaster-firesitesttistics-content">
          <div className="ccs-disaster-firesitesttistics-item">
            <div className="ccs-disaster-firesitesttistics-item-name">
              <img src="upload/sfcc/common/image/已撤销.png" alt="" />
            </div>
            <div className="ccs-disaster-firesitesttistics-item-value">
              <p style={{ color: '#0FEBFF', fontWeight: 600 }}>{dangerStatisticsData[6] || ''}</p>
              <p>已撤销</p>
            </div>
          </div>
          <div className="ccs-disaster-firesitesttistics-item">
            <div className="ccs-disaster-firesitesttistics-item-name">
              <img src="upload/sfcc/common/image/治理完成.png" alt="" />
            </div>
            <div className="ccs-disaster-firesitesttistics-item-value">
              <p style={{ color: '#9AEF4D', fontWeight: 600 }}>{dangerStatisticsData[5] || ''}</p>
              <p>治理完成</p>
            </div>
          </div>
        </div>

      </ScreenCard>
    );
  }
}

export default DangerStatistics;
