import { request, gateWay } from '@gm/graphmod-utils';

const {
  commonGet,
  formatUrl,
  completePrefix
} = request;

export const UrlConsts = {
  buildVedioTreeUrl: () => completePrefix()(gateWay.ccs, 'fire-building/stationBuildingTree?stationCode={stationCode}'), // 获取建筑树 get
  vedioPageListUrl: () => completePrefix()(gateWay.ccs, 'fire-video/{stationCode}/page?current={page}&size={size}' +
  '&name={name}&videoMrid={mrid}&buildingMrids={buildingMrids}'), // 监控视屏分页列表 get
  fireEquipListUrl: () => completePrefix()(gateWay.equip, 'building/video/fire/equip?videoId={id}'), // 获取视频点下电力设备列表 get
  electricEquipListUrl: () => completePrefix()(gateWay.equip, 'building/video/power/equip?videoId={id}') // 获取视频点下消防设备列表 get
};
/**
 * 获取建筑树
 * @param {*} id 视频点id
 */
export const buildVedioTreeAction = (stationCode) => {
  return commonGet(formatUrl(UrlConsts.buildVedioTreeUrl(), { stationCode }));
};

/**
 * 监控视屏分页列表
 * @param {*} page
 * @param {*} size
 * @param {*} filter 过滤条件
 */
export const vedioPageListAction = (page, size, name, mrid, stationCode, buildingMrids) => {
  return commonGet(formatUrl(UrlConsts.vedioPageListUrl(), { page, size, stationCode, name, mrid, buildingMrids }));
};

/**
 * 获取视频点下电力设备列表
 * @param {*} id 视频点id
 */
export const fireEquipListAction = (id) => {
  return commonGet(formatUrl(UrlConsts.fireEquipListUrl(), { id }));
};

/**
 * 获取视频点下消防设备列表
 * @param {*} id 视频点id
 */
export const electricEquipListAction = (id) => {
  return commonGet(formatUrl(UrlConsts.electricEquipListUrl(), { id }));
};
