import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Tabs, Button } from 'amos-framework';
import ImageConsts from '@gm/graphmod-assets';
import { DetailsList } from '@gm/graphmod-common';
import {
  fireEquipListAction,
  electricEquipListAction
} from './../api';

const { TabList, Tab, TabPanel } = Tabs;
/**
 * 视频详情（关联消防设备和电力设备）
 *
 * @class VedioDetailsPane
 * @extends {Component}
 */
class VedioDetailsPane extends Component {

  static propTypes = {
    onHide: PropTypes.func,
    info: PropTypes.object,
    closeDetails: PropTypes.func
  };

  static defaultProps = {
    info: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      fireEquipList: [], // 消防设备列表
      electricEquipList: [] // 电力设备列表
    };
  }

  componentDidMount() {
    this.requestList();
  }

  componentDidUpdate(prevProps) {
    if (prevProps.info.id !== this.props.info.id) {
      this.requestList();
    }
  }

  requestList = () => {
    const { info } = this.props;
    if (info.id) {
      this.setState({ fireEquipList: [], electricEquipList: [] });
      fireEquipListAction(info.id).then(d => this.setState({ fireEquipList: d || [] }));
      electricEquipListAction(info.id).then(d => this.setState({ electricEquipList: d || [] }));
    }
  }

  /**
   * 关闭详情
   */
  closeDetails = () => {
    const { closeDetails } = this.props;
    closeDetails();
  }

  renderListItem = (data) => {
    return (
      <div key={data.id} className="ccs-vediodetails-equiplist-item">
        <div className="ccs-vediodetails-equiplist-title">
          {data.equipmentName}
        </div>
        <div className="ccs-vediodetails-equiplist-value">
          <span>编码：</span>
          <span>{data.mrid}</span>
        </div>
        <div className="ccs-vediodetails-equiplist-value">
          <span>位置：</span>
          <span>{data.position}</span>
        </div>
      </div>
    );
  }

  render() {
    const { info } = this.props;
    const { fireEquipList, electricEquipList } = this.state;
    const { name } = info || {};
    return (
      <div className="ccs-vediodetails-pane mod-com-scrollbar">
        <div className="ccs-vediodetails-pane-top">
          <div className="ccs-vediodetails-pane-img">
            <div className="ccs-vediodetails-pane-img-centent">
              <img src={ImageConsts.common.vedioBigIcon} alt="" />
            </div>
          </div>
          <div className="ccs-vediodetails-pane-name">
            <label>{name}</label>
          </div>
          <div className="ccs-vediodetails-pane-form">
            <DetailsList
              data={info}
              configs={[
                { key: 'mrid', label: '编码' },
                { key: 'position', label: '位置' }
              ]}
            />
          </div>
        </div>
        <div className="ccs-vediodetails-equiplist">
          <Tabs mode="line">
            <TabList>
              <Tab>消防设备</Tab>
              <Tab>电力设备</Tab>
            </TabList>
            <TabPanel>
              {fireEquipList.map(d => this.renderListItem(d))}
            </TabPanel>
            <TabPanel>
              {electricEquipList.map(d => this.renderListItem(d))}
            </TabPanel>
            <div className="ccs-vediodetails-equiplist-button">
              <Button onClick={() => this.closeDetails()}>关闭详情</Button>
            </div>
          </Tabs>
        </div>
      </div>
    );
  }
}

export default VedioDetailsPane;
