const getBitLength = (value) => {
  if (value !== null || value !== undefined) {
    return (new window.Blob([`${value}`])).size;
  } else {
    return 0;
  }
};
const minWidth = 40;
const maxWidth = 500;
/**
 * 根据数据字符长度计算列宽（默认取前20条）
 * @param {*} rows
 * @param {*} column
 * @param {*} rowLength
 */
const calcColumnWidth = (rows, column, rowLength = 20) => {
  let headLength = getBitLength(`${column.alias}(${column.type})`) + 1;
  let maxLength = 0;
  if (rows && rows.length > 0) {
    for (let i = 0; i < rowLength; i++) {
      if (rows[i] && rows[i][column.name]) {
        const l = getBitLength(rows[i][column.name]);
        if (l > maxLength) {
          maxLength = l;
        }
      }
    }
  }
  //通过统计表头各个字节数对应实际字符所占宽度，在通过线性回归算法的到的方程式计算最大的宽度
  const headWidth = -19.76 + 10.25 * headLength - 0.0935 * Math.pow(headLength, 2) + 23;
  //通过统计数据中字段各个字节数对应实际字符所占宽度，在通过线性回归算法的到的方程式计算最大的宽度
  const bodyWidth = -4.506 + (6.696 * maxLength) - (0.01485 * Math.pow(maxLength, 2)) + 35;
  let width = headWidth > bodyWidth ? headWidth : bodyWidth;

  if (width < minWidth) {
    width = minWidth;
  }
  if (width > maxWidth) {
    width = maxWidth;
  }
  return width;
};

export default {
  calcColumnWidth
};
