import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Button, Icon } from 'amos-framework';
import './ModelInput.scss';
/**
 * 输入框内部右侧有点击按钮
 *
 * @class ModelInput
 * @extends {Component}
 */
class ModelInput extends Component {

  static propTypes = {
    value: PropTypes.string,
    className: PropTypes.string,
    onClear: PropTypes.func,
    children: PropTypes.any,
    text: PropTypes.string, // 按钮文字
    disabled: PropTypes.bool, // 是否禁用
    onClick: PropTypes.func // 点击按钮
  };

  static defaultProps = {
    onClick(){}
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }


  render() {
    const { text, className, value, disabled, onClick, children, onClear, ...other } = this.props;
    return (
      <div className={`mods-modelinput ${className || ''}`}>
        <Input className="mods-modelinput-input" disabled value={value} {...other} />
        { value && <Icon icon="cancel" onClick={onClear} /> }
        <Button className="mods-modelinput-btn" disabled={disabled} onClick={onClick}>{text}</Button>
        {children}
      </div>
    );
  }
}

export default ModelInput;
