import React from 'react';
import { Checkbox , FormBuilder, Connect } from 'amos-framework';
import './index.scss';

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;
const CheckboxGroup = Checkbox.Group;

/**
 *CheckboxSelect
 * 数据格式满足 items: [{ id, name, ... }]
 * @class CheckboxSelect
 * @extends {Component}
 */
@enhanceForm
class CheckboxSelect extends BasicForm {
  constructor(props) {
    super(props);
  }

  render() {
    const { data, onChange } = this.props;
    const { items = [] } = data;
    return (
      <CheckboxGroup className="check-box-group" onChange={onChange}>
        {
          items.map(element => {
            const { key, label, ...rest } = element;
            return <Checkbox className="check-box" key={key} value={label} {...rest}>{label}</Checkbox>;
          })
        }
      </CheckboxGroup>
    );
  }
}

export default CheckboxSelect;