import React from 'react';
import PropTypes from 'prop-types';
import { FormBuilder, Connect } from 'amos-framework';
import './index.scss';

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;

/**
 * IconShow
 * 图标输入框展示
 * @extends {Component}
 */
@enhanceForm
class IconShow extends BasicForm {
  constructor(props) {
    super(props);
  }

  render() {
    let { value } = this.props;
    let arrTmp = [];
    let state;
    let text;
    if (value) {
      arrTmp = value.split('#');
      [state, text] = arrTmp;
    }
    // 0#已超期、1#正常、2#即将超期、
    return (
      <div className="input-icon-box">
        {
          state == '0' ?
            (<span>
              <span className="input-icon" />
              <span className="input-text">{text}</span>
            </span>)
            :
            state == '1' ?
              (<span>
                <span className="input-icon1" />
                <span className="input-text1">{text}</span>
              </span>)
              :
              (<span>
                <span className="input-icon2" />
                <span className="input-text2">{text}</span>
              </span>)
        }
      </div>
    );
  }
}

IconShow.propTypes = {
  onChange: PropTypes.func,
  value: PropTypes.string
};
export default IconShow;
