import React from 'react';
import PropTypes from 'prop-types';
import { FormBuilder, Connect, Input } from 'amos-framework';
import './index.scss';

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;

/**
 * PwdInput
 * 密码输入框
 * @extends {Component}
 */
@enhanceForm
class PwdInput extends BasicForm {
  constructor(props) {
    super(props);
  }

  handleChange = (value) => {
    const { onChange } = this.props;
    onChange(value);
  }

  render() {
    const cls = this.getClassNames('param-treeselect');
    let { value } = this.props;
    return (
      <div className={cls}>
        <Input
          value={value}
          type="password"
          placeholder="请输入密码"
          onChange={(e) => this.handleChange(e.target.value)}
        />
      </div>
    );
  }
}

PwdInput.propTypes = {
  onChange: PropTypes.func,
  value: PropTypes.string
};
export default PwdInput;
