import React from 'react';
import { Radio, FormBuilder, Connect } from 'amos-framework';

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;
const RadioGroup = Radio.Group;

/**
 * Radio param
 * 数据格式满足数据字典  items: [{ id, name, ... }]
 * @class RadioParam2
 * @extends {Component}
 */
@enhanceForm
class RadioParam2 extends BasicForm {
  constructor(props) {
    super(props);
    this.validConfig('type=radio', 'radios');
  }

  render() {
    const cls = this.getClassNames('param-radio');
    const { data, value, onChange } = this.props;
    const { items = [] } = data;
    return (
      <RadioGroup className={cls} value={value} onChange={onChange}>
        {
          items.map(r => {
            const { id, name, ...rest } = r;
            return <Radio key={id} value={id} {...rest}>{name}</Radio>;
          })
        }
      </RadioGroup>
    );
  }
}

export default RadioParam2;
