import React from 'react';
import { MultiSelect, FormBuilder, Connect } from 'amos-framework';

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;
const Option = MultiSelect.Option;
const SingleTagSelect = MultiSelect.SingleTagSelect;

/**
 * SingleTagSelect
 *
 * @class SingleTagSelect
 * @extends {BasicForm}
 */
@enhanceForm
class SingleTagSelect2 extends BasicForm {

  constructor(props) {
    super(props);
    this.state = {
      value: props.value || props.defaultValue || ''
    };
  }

  componentWillReceiveProps(nextProps) {
    if (this.props.value !== nextProps.value){
      this.setState({
        value: nextProps.value
      });
    }
  }

  handleChange = (e, value) => {
    this.setState({
      value
    });
    this.props.onChange && this.props.onChange(value);
  }

  render() {
    const cls = this.getClassNames('param-singletagselect');
    const { value } = this.state;
    let { data = [] } = this.props;
    const { items = [] } = data;
    return (
      <div className={cls}>
        <SingleTagSelect {...this.props} tagable value={value} onChange={this.handleChange}>
          {
            items.map(d => <Option key={d.key}>{d.label}</Option>)
          }
        </SingleTagSelect>
      </div>
    );
  }
}

SingleTagSelect2.propTypes = {};

export default SingleTagSelect2;
