import React from 'react';
import { FormBuilder, Connect, Tree, Icon, Modal } from 'amos-framework';
import { recursive } from 'amos-designer';
import imageStatic from '@gm/graphmod-assets';
import './index.scss';

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;
const TreeNode = Tree.TreeNode;
/**
 * TreeSelectModel
 * 下拉树弹框
 * @class TreeSelectModel
 * @extends {Component}
 */
@enhanceForm
class TreeSelectModel extends BasicForm {
  constructor(props) {
    super(props);
    this.state = {
      defaultvalue: '',
      posVisible: false,
      data: [],
      expandedKeys: [],
      autoExpandParent: true,
      checkedKeys: [],
      selectedKeys: []
    };
  }

  componentWillReceiveProps(nextProps) {
    const tarItem = recursive(this.props.data.items).find(e => e.key === nextProps.value) || {};
    this.setState({
      defaultvalue: tarItem.title
    });
  }

  showModel = () => {
    this.setState({
      posVisible: true
    });
  }

  cancel = () => {
    this.setState({
      posVisible: false
    });
  }

  onExpand = (expandedKeys, ...args) => {
    console.log('onExpand', args);
    this.setState({
      expandedKeys
    });
  }

  onCheck = (checkedKeys) => {
    console.log('onCheck', checkedKeys);
    this.setState({ checkedKeys });
  }

  onSelect = (selectedKeys, info) => {
    console.log('onSelect', selectedKeys, info);
    const { onChange } = this.props;
    onChange(selectedKeys[0]);
    this.setState({
      selectedKeys
    });
  }

  renderTreeNodes = (data) => {
    return data.map((item) => {
      if (item.children) {
        return (
          <TreeNode title={item.title} key={item.key} dataRef={item}>
            {this.renderTreeNodes(item.children)}
          </TreeNode>
        );
      }
      return <TreeNode key={item.key} {...item} />;
    });
  }

  renderContent() {
    const { data, value } = this.props;
    return (
      <div className="tree-select-model-content">
        <Tree
          showIcon
          onExpand={this.onExpand}
          defaultExpandAll
          onCheck={this.onCheck}
          onSelect={this.onSelect}
          defaultSelectedKeys={[value]}
          icon={({ img, isLeaf, expanded }) => {
            if (img){
              return <Icon icon={img} />;
            }
            if (isLeaf) {
              return <Icon icon="file" />;
            }
            return <Icon icon={expanded ? 'folder-open' : 'folder'} />;
          }}
        >
          { data.items.length > 0 ? this.renderTreeNodes(data.items) : <div>暂无数据</div>}
        </Tree>
      </div>
    );
  }
  render() {
    const { posVisible, defaultvalue } = this.state;
    return (
      <div className='tree-select-model-box'>
        <div className='tree-select-model'>
          <div className='tree-select-model-input'>
            <div class="amos-tree-select-title amos-text-overflow amos-popover-trigger">{defaultvalue ? defaultvalue : '请选择'}</div>
          </div>
          <div className='tree-select-model-icon'>
            <img src={imageStatic.common.addColor} alt="" onClick={this.showModel}/>
          </div>
        </div>
        <Modal
          style={{ height: '88%'}}
          header='请选择'
          visible={posVisible}
          noDefaultFooter
          fullscreen
          onCancel={this.cancel}
          content={this.renderContent()}
        />
      </div>
    );
  }
}

export default TreeSelectModel;
