import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { GraphIcon, BarBtnGroup, IconBtnOne } from 'amos-designer';

/**
 * 通用 header, 默认添加返回
 * @class CommonHeader
 * @extends {Component}
 */
class CommonHeader extends Component {
  static contextTypes = {
    browserHistory: PropTypes.object
  };

  handleBack = () => {
    this.context.browserHistory.goBack();
  }

  render() {
    const { className } = this.props;
    const cls = classNames('gm-common-header', className);
    return (
      <div className={cls}>
        <BarBtnGroup>
          <IconBtnOne
            title="返回"
            icon={<GraphIcon icon="/public/webico/function/层级-上一级.png" />}
            onClick={this.handleBack}
          />
        </BarBtnGroup>
      </div>
    );
  }
}

CommonHeader.propTypes = {
  className: PropTypes.string
};

export default CommonHeader;
