import { errorTip } from 'amos-designer';
// import { WebControl } from './jsWebControl-1.0.0.min.js';
/**
 * 设备模型处理器
 */
export default class ModelProcessor {
  constructor(WebControl, params = {}, callback) {
    const { appkey, secret, ip, port, iServicePortStart, iServicePortEnd, layout, width, height } = params;
    this.oWebControl = null;
    this.appkey = appkey;
    this.secret = secret;
    this.ip = ip;
    this.port = port;
    this.iServicePortEnd = iServicePortEnd;
    this.iServicePortStart = iServicePortStart;
    this.layout = layout;
    this.callback = callback;
    this.width = width;
    this.height = height;
    this.WebControl = WebControl;
  }

  // Setting window clipping
  setWndCutting = (iWidth, iHeight) => {
    const iCoverLeft = 0;
    const iCoverTop = 0;
    const iCoverRight = 0;
    const iCoverBottom = 0;

    this.oWebControl.JS_RepairPartWindow(0, 0, 900, 600);
    //The width below deliberately sets two large pixels, which will leave a black line when setting 900.
    if (iCoverLeft != 0) {
      this.oWebControl.JS_CuttingPartWindow(0, 0, iCoverLeft, 600);
    }
    if (iCoverTop != 0) {
      this.oWebControl.JS_CuttingPartWindow(0, 0, 902, iCoverTop);
    }
    if (iCoverRight != 0) {
      this.oWebControl.JS_CuttingPartWindow(902 - iCoverRight, 0, iCoverRight, 600);
    }
    if (iCoverBottom != 0) {
      this.oWebControl.JS_CuttingPartWindow(0, 600 - iCoverBottom, 902, iCoverBottom);
    }
  }

  initPlugin = (id) => {
    // const id = uniqueId();
    const me = this;
    this.oWebControl = new this.WebControl({ // 创建 WebControl 实例
      szPluginContainer: id, // DIV 窗口识别
      iServicePortStart: this.iServicePortStart || 17010, // 开始端口号
      iServicePortEnd: this.iServicePortEnd || 17019, // 结束端口号
      szClassId: "DD55D830-A127-49bd-944C-36AF7CCB245A", // 用于通过 IE10 调用 ActiveX 控制的 CLSID
      cbConnectSuccess: function () {
        // 创建 WebControl 实例成功
        me.oWebControl.JS_StartService("window", {
          dllPath: "WebInterLayer.dll"
        }).then(function () {
          me.oWebControl.JS_CreateWnd(id, me.width || 900, me.height || 600).then(function () {
            console.log("JS_CreateWnd success");
            // me.onResize();
            // window.addEventListener('resize', me.onResize);
            me.init();
          });
        }, function () {

        });
      },
      cbConnectError: function () {
        // 创建 WebControl 实例失败
        console.log("cbConnectError");
        me.oWebControl = null;
        WebControl.JS_WakeUp("HCVideoSDKWebControl://");
        initCount++;
        if (initCount < 3) {
          setTimeout(function () {
            me.initPlugin();
          }, 3000)
        } else {
        }
      },
      cbConnectClose: function () {
        //插件使用过程中发生断开与插件服务连接时回调的 bNormalClose 的值："false"-异常断开， "true"-正常断开
        console.log("cbConnectClose");
        me.oWebControl = null;
      }
    });
  }

  init = () => {
    if (!this.appkey) {
      // errorTip('appkey为空');
      // showCBInfo(msgObj.appkeyIsEmpty, 'error');
      return
    }
    if (!this.secret) {
      // errorTip('secret为空');
      // showCBInfo(msgObj.secretIsEmpty, 'error');
      return
    }
    if (!this.ip) {
      // errorTip('ip地址为空');
      return
    }
    if (!this.port) {
      // errorTip('端口为空');
      return
    }
    console.log({
      appkey: this.appkey,
      secret: this.secret,
      ip: this.ip,
      playMode: 0, // preview
      port: this.port,
      layout: this.layout
    });

    this.oWebControl.JS_RequestInterface({
      funcName: "init",
      argument: JSON.stringify({
        appkey: this.appkey,
        secret: this.secret,
        ip: this.ip,
        playMode: 0, //  preview
        port: this.port,
        showToolbar: 0,
        showSmart: 0,
        layout: this.layout
      })
    }).then(function (oData) {
      this.callback();
    });
  }

  startPreview = (camera, windowID) => {
    const { cameraIndexCode, streamMode, transMode, gpuMode, viewMode } = camera;

    if (!cameraIndexCode) {
      // errorTip('请选择要播放的视频');
      return
    }

    this.oWebControl.JS_RequestInterface({
      funcName: "startPreview",
      argument: JSON.stringify({
        cameraIndexCode: cameraIndexCode,
        streamMode: streamMode,
        transMode: transMode,
        gpuMode: gpuMode,
        windowID: viewMode == 1 ? -1 : windowID
      })
    }).then(function (oData) {
    });
  }

  stopAllPreview = () => {
    this.oWebControl.JS_RequestInterface({
      funcName: "stopAllPreview"
    }).then(function (oData) {

    });
  }

  uninit = () => {
    this.oWebControl.JS_RequestInterface({
      funcName: "uninit"
    }).then(function (oData) {
    });
  }

  onunload = () => {
    if (this.oWebControl != null) {
      try {
        this.uninit();
        this.oWebControl.JS_Disconnect().then(function () {
        }, function () { });
      } catch (error) {
        
      }
    }
  }
}

