import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal } from 'amos-framework';
import ImageConsts from '@gm/graphmod-assets';
import './image.scss';

/**
 * 图片展示-包含点击查看大图
 *
 * @class Image
 * @extends {Component}
 */
class Image extends Component {

  static propTypes = {
    src: PropTypes.any
  };

  static defaultProps = {

  };

  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  onClick = () => {
    this.setState({ visible: true });
  }

  onCancel = () => {
    this.setState({ visible: false });
  }

  render() {
    const { src, ...other } = this.props;
    const { visible } = this.state;
    return (
      <div {...other}>
        <img src={src ? src : ImageConsts.common.noimage} alt="" />
        { src && <a onClick={this.onClick}>查看大图</a> }
        <Modal
          className="eb-look-maximg-wrapper"
          visible={visible}
          onCancel={this.onCancel}
          width="auto"
          noDefaultFooter
          noDefaultHeader
          content={<img src={src ? src : ImageConsts.common.noimage} alt="" />}
        />
      </div>
    );
  }
}

export default Image;
