import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { getPropsValue } from 'amos-designer';
import './DetailsList.scss';
/**
 * 对象详情列表展示组件
 *
 * @class DetailsList
 * @extends {Component}
 */
class DetailsList extends Component {

  static propTypes = {
    detailSetting: PropTypes.array,
    data: PropTypes.object // 数据对象
  };

  static defaultProps = {
    configs: [],
    data: {}
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  render() {
    const { detailSetting, data } = this.props;
    return (
      <div className="gm-tablepage-details-list">
        {
          (detailSetting || []).map((e, index) => (
            <div key={e.key} className="gm-tablepage-details-item">
              {
                e.title && <div
                  className="gm-tablepage-details-label"
                >
                  <label>{e.title}：</label>
                </div>
              }
              <div
                className="gm-tablepage-details-value"
                style={{ paddingLeft: e.title ? '0.5rem' : 0 }}
              >
                {
                  e.render ? e.render(data, e, index) :
                    <div
                      className="gm-tablepage-details-cell"
                      title={getPropsValue(data, e.dataIndex, '')}
                    >
                      <span>{getPropsValue(data, e.dataIndex, '')}</span>
                    </div>
                }
              </div>
            </div>
          ))
        }
      </div>
    );
  }
}

export default DetailsList;
