import React from 'react';
import PropTypes from 'prop-types';
import { SearchBtn, CancelBtn } from 'amos-designer';
import classnames from 'classnames';
import ImageConsts from '@gm/graphmod-assets';
import './Filter.scss';
/**
 * 筛选面板容器
 *
 * @class FilterPane
 * @extends {Component}
 */
function FilterPane(props) {
  const { children, onReset, onSearch, show, onHide, className, style } = props || {};
  return (
    <div className={classnames('gm-tablepage-filter-pane', 'gm-scrollbar', className)} style={{ display: show ? 'block' : 'none', ...style || {} }}>
      <div className="gm-tablepage-filter-pane-title">
        <span>筛选</span>
        {onHide && <img src={ImageConsts.mods.right} onClick={onHide} alt="" />}
      </div>
      <div className="gm-tablepage-filter-pane-content">
        {children}
      </div>
      <div className="gm-tablepage-filter-pane-footer">
        <CancelBtn onClick={onReset}>重置</CancelBtn>
        <SearchBtn onClick={onSearch}>查询</SearchBtn>
      </div>
    </div>
  );
}

FilterPane.propTypes = {
  style: PropTypes.object,
  className: PropTypes.any,
  children: PropTypes.any,
  show: PropTypes.bool,
  onReset: PropTypes.func,
  onSearch: PropTypes.func,
  onHide: PropTypes.func
};

FilterPane.defaultProps = {
  onReset() { },
  onSearch() { }
};

export default FilterPane;
