import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { StdForm } from 'amos-designer';
import { DatePicker } from 'amos-antd';
import moment from 'moment';
import { Input, Select, TreeSelect, InputNumber, MultiSelect, Cascader } from 'amos-framework';
import FilterPane from './FilterPane';

/**
 *
 *
 * @class BizTableFilter
 * @extends {Component}
 */
class BizTableFilter extends Component {
  static propTypes = {
    filters: PropTypes.object,
    show: PropTypes.bool,
    renderFilters: PropTypes.func,
    filterSetting: PropTypes.array,
    onFilterChange: PropTypes.func,
    onSearch: PropTypes.func,
    onReset: PropTypes.func,
    onShowFilter: PropTypes.func
  };

  static defaultProps = {

  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  onChange = (varName, value) => {
    const { onFilterChange, filters } = this.props;
    filters[varName] = value;
    onFilterChange(filters);
  };

  renderItem = (data) => {
    const { filters } = this.props;
    switch (data.type) {
      case 'inputNumber':
        return <InputNumber placeholder="请输入" value={filters[data.dataIndex]} onChange={e => this.onChange(data.dataIndex, e)} />;
      case 'checked':
        return (
          <Select
            popoverClassName="gm-common-popover"
            placeholder="请选择"
            value={filters[data.dataIndex] === undefined ?
              filters[data.dataIndex] :
              filters[data.dataIndex] ? '1' : '0'}
            onChange={e => this.onChange(data.dataIndex, e ? !!Number(e) : undefined)}
          >
            <Select.Option>所有</Select.Option>
            <Select.Option value="1">是</Select.Option>
            <Select.Option value="0">否</Select.Option>
          </Select>
        );
      case 'select':
        return data.selectTypeMultiple ?
          <MultiSelect popoverClassName="gm-common-popover" placeholder="请选择" values={filters[data.dataIndex]} onChange={e => this.onChange(data.dataIndex, e)}>
            {
              data.typeData.map(e => (
                <MultiSelect.Option key={e.value} value={e.value}>
                  {e.label}
                </MultiSelect.Option>
              ))
            }
          </MultiSelect> :
          <Select popoverClassName="gm-common-popover" placeholder="请选择" value={filters[data.dataIndex]} onChange={e => this.onChange(data.dataIndex, e)}>
            <Select.Option>所有{data.title}</Select.Option>
            {
              data.typeData.map(e => (
                <Select.Option key={e.value} value={e.value}>
                  {e.label}
                </Select.Option>
              ))
            }
          </Select>;
      case 'selectTree':
        return (
          <TreeSelect
            multiple={data.selectTreeMultiple}
            dataSource={data.typeData}
            value={filters[data.dataIndex]}
            onChange={value => this.onChange(data.dataIndex, value)}

          />
        );
      case 'datetime':
        return (
          <DatePicker
            className="gm-common-popover"
            popupStyle={{ backgroundColor: 'transparent' }}
            placeholder="请选择"
            style={{ width: '100%' }}
            value={filters[data.dataIndex] ? moment(filters[data.dataIndex], data.dataPickerFormat || 'YYYY-MM-DD HH:mm:ss') : undefined}
            onChange={(e, dateString) => this.onChange(data.dataIndex, dateString)}
            showTime
            format={data.dataPickerFormat || 'YYYY-MM-DD HH:mm:ss'}
          />
        );
      case 'cascader':
        return (
          <Cascader
            options={data.typeData}
            value={`${filters[data.dataIndex] || ''}`}
            onChange={value => this.onChange(data.dataIndex, value)}
          />
        );
      default:
        return <Input placeholder="请输入" value={filters[data.dataIndex]} onChange={e => this.onChange(data.dataIndex, e.target.value)} />;
    }
  }
  render() {
    const { onReset, onSearch, show, renderFilters, filters, filterSetting, onShowFilter } = this.props;
    return (
      <FilterPane className="gm-tablepage-filter gm-tablepage-scrollbar" show={show} onReset={onReset} onHide={onShowFilter} onSearch={onSearch}>
        {
          renderFilters ? renderFilters(filters, this.onChange) :
            <React.Fragment>
              {(filterSetting || []).map(e =>
                e.title && e.dataIndex && <StdForm key={e.key} label={e.title} vertical col>
                  {
                    this.renderItem(e)
                  }
                </StdForm>
              )}
            </React.Fragment>
        }
      </FilterPane>
    );
  }
}

export default BizTableFilter;
