import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form } from 'amos-framework';
import FilterPane from './../biz/FilterPane';
import './FileFilter.scss';

/**
 * 消防-筛选面板
 *
 * @class FireFilter
 * @extends {Component}
 */
class FireFilter extends Component {
  static propTypes = {
    filters: PropTypes.object,
    show: PropTypes.bool,
    onFilterChange: PropTypes.func,
    onSearch: PropTypes.func,
    onReset: PropTypes.func,
    className: PropTypes.any,
    width: PropTypes.any,
    renderFilters: PropTypes.func,
    onShowFilter: PropTypes.func
  };

  static defaultProps = {
    renderFilters(){}
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  onChange = (varName, value) => {
    const { onFilterChange, filters } = this.props;
    filters[varName] = value;
    onFilterChange(filters);
  }

  render() {
    const { onReset, onSearch, filters, show, onShowFilter, className, renderFilters } = this.props;
    return (
      <FilterPane className={className} show={show} onReset={onReset} onSearch={onSearch} onHide={onShowFilter}>
        <Form className="eb-form-tablelist-filter-content" ref={form => this.form = form} model={filters}>
          {
            renderFilters(this.onChange, filters)
          }
        </Form>
      </FilterPane>
    );
  }
}

export default FireFilter;
