import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import './FormCollapsePane.scss';
import ImageConsts from '@gm/graphmod-assets';

/**
 * Form折叠面板
 *
 * @class FormCollapsePane
 * @extends {Component}
 */
class FormCollapsePane extends Component {

  static propTypes = {
    hide: PropTypes.bool,
    className: PropTypes.string,
    title: PropTypes.string,
    children: PropTypes.any
  };

  constructor(props) {
    super(props);
    this.state = {
      open: true
    };
  }

  handleOpen = () => {
    this.setState({ open: !this.state.open });
  }

  render() {
    const { title, children, className, hide } = this.props;
    const { open } = this.state;
    if (hide) {
      return null;
    }
    return (
      <div className={classnames('mod-com-formcollapsepane', className)}>
        <div className="mod-com-formcollapsepane-title">
          <span onClick={this.handleOpen}>{title} <img src={ImageConsts.common.selecticon} alt="" /></span>
        </div>
        <div className="mod-com-formcollapsepane-content" style={{ display: open ? 'block' : 'none' }}>
          { children }
        </div>
      </div>
    );
  }
}

export default FormCollapsePane;
