import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import AmosSplitPane  from './split';
import './style.scss';
/**
 * 分割面板（采用amos-framework中的SplitPane）
 * 修改SplitPane中子节点height 100%在部分浏览器中不起效问题
 *
 * @class SplitPane
 * @extends {Component}
 */
class SplitPane extends Component {

  static propTypes = {
    children: PropTypes.any,
    vertical: PropTypes.string,
    className: PropTypes.string,
    dataConfig: PropTypes.object,
    style: PropTypes.object
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  componentDidMount() {
    // 优先使用style配置，其次使用dataConfig
    const { backgroundColor } = this.props.style || {};
    if (!backgroundColor){
      const confBackgroundColor = this.props.dataConfig && this.props.dataConfig.backgroundColor ? this.props.dataConfig.backgroundColor : 'white';
      if (this.pane.containerRef) {
        let splitpaneDom = this.pane.containerRef.getElementsByClassName('mods-com-splitpane')[0];
        if (splitpaneDom) {
          splitpaneDom.style.background = confBackgroundColor;
        }
        this.pane.containerRef.style.background = confBackgroundColor;
      }
    }
  }

  render() {
    const { children, className, ...other } = this.props;
    const styleFirst = { height: '100%', width: '100%', position: 'absolute' };
    const styleSecond = { height: '100%', width: '100%', position: 'absolute' };
    if (this.props.vertical) {
      styleSecond.height = 'calc(100% + 3px)';
    } else {
      styleSecond.width = 'calc(100% + 3px)';
    }
    return (
      <AmosSplitPane ref={node => this.pane = node} {...other} preventEventOnResizing className={classnames(className, 'mods-com-splitpane')}>
        { children[0] && <div style={styleFirst}>{children[0]}</div> }
        { children[1] && <div style={styleSecond}>{children[1]}</div> }
      </AmosSplitPane>
    );
  }
}

export default SplitPane;
