import React, { Component } from 'react';
import PropTypes from 'prop-types';
import moment from 'moment';
import cls from 'classnames';

function Time(props) {
  const { color, width, height, count, digit = 2, barWidth = 2 } = props || {};
  let nums = [];
  let _nums = [];
  if (!count) {
    _nums = ['0'];
  } else {
    _nums = String(count).split('');
  }
  if (_nums.length < digit) {
    nums = (Array(digit).join(0) + count).slice(-digit).split('');
  } else {
    nums = _nums;
  }
  const comStyle = {
    borderColor: color,
    backgroundColor: color
  };
  return (
    <React.Fragment>
      {
        nums.map((e, index) => (
          <div key={index} className={cls('gm-time-digits', `gm-time-digits-${e}`)} style={{ width, height, color }}>
            <span
              style={{ ...comStyle, left: barWidth + 1, width: `calc(100% - ${barWidth * 2 + 2}px)`, height: barWidth, top: 0 }}
              className="gm-time-digits-item gm-time-digits-d1"
            >
              <span className="before" style={{ borderWidth: `0 ${barWidth}px ${barWidth}px 0`, left: -barWidth, borderRightColor: 'inherit' }} />
              <span className="after" style={{ borderWidth: `0 0 ${barWidth}px ${barWidth}px`, right: -barWidth, borderLeftColor: 'inherit' }} />
            </span>
            <span
              style={{ ...comStyle, left: barWidth + 1, width: `calc(100% - ${barWidth * 2 + 2}px)`, height: barWidth, top: `calc(50% - ${barWidth / 2}px)` }}
              className="gm-time-digits-item gm-time-digits-d2"
            >
              <span
                className="before"
                style={{ borderWidth: `${barWidth / 2}px ${barWidth / 2 + 1}px ${barWidth / 2}px`, left: -barWidth - 2, borderRightColor: 'inherit' }} />
              <span
                className="after"
                style={{ borderWidth: `${barWidth / 2}px ${barWidth / 2 + 1}px ${barWidth / 2}px`, right: -barWidth - 2, borderLeftColor: 'inherit' }} />
            </span>
            <span
              style={{ ...comStyle, left: barWidth + 1, width: `calc(100% - ${barWidth * 2 + 2}px)`, height: barWidth, bottom: 0 }}
              className="gm-time-digits-item gm-time-digits-d3"
            >
              <span className="before" style={{ borderWidth: `${barWidth}px ${barWidth}px 0 0`, left: -barWidth, borderRightColor: 'inherit' }} />
              <span className="after" style={{ borderWidth: `${barWidth}px 0 0 ${barWidth}px`, right: -barWidth, borderLeftColor: 'inherit' }} />
            </span>
            <span
              style={{ ...comStyle, top: barWidth + 2, width: barWidth, height: `calc(50% - ${barWidth * 2 + 2}px)`, left: 0 }}
              className="gm-time-digits-item gm-time-digits-d4"
            >
              <span className="before" style={{ borderWidth: `0 ${barWidth}px ${barWidth}px 0`, top: -barWidth, borderBottomColor: 'inherit' }} />
              <span className="after" style={{ borderWidth: `0 0 ${barWidth}px ${barWidth}px`, bottom: -barWidth, borderLeftColor: 'inherit' }} />
            </span>
            <span
              style={{ ...comStyle, top: barWidth + 2, width: barWidth, height: `calc(50% - ${barWidth * 2 + 2}px)`, right: 0 }}
              className="gm-time-digits-item gm-time-digits-d5"
            >
              <span className="before" style={{ borderWidth: `0 0 ${barWidth}px ${barWidth}px`, top: -barWidth, borderBottomColor: 'inherit' }} />
              <span className="after" style={{ borderWidth: `${barWidth}px 0 0 ${barWidth}px`, bottom: -barWidth, borderTopColor: 'inherit' }} />
            </span>
            <span
              style={{ ...comStyle, top: `calc(50% + ${barWidth}px)`, width: barWidth, height: `calc(50% - ${barWidth * 2 + 2}px)`, left: 0 }}
              className="gm-time-digits-item gm-time-digits-d6"
            >
              <span className="before" style={{ borderWidth: `0 ${barWidth}px ${barWidth}px 0`, top: -barWidth, borderBottomColor: 'inherit' }} />
              <span className="after" style={{ borderWidth: `0 0 ${barWidth}px ${barWidth}px`, bottom: -barWidth, borderLeftColor: 'inherit' }} />
            </span>
            <span
              style={{ ...comStyle, top: `calc(50% + ${barWidth}px)`, width: barWidth, height: `calc(50% - ${barWidth * 2 + 2}px)`, right: 0 }}
              className="gm-time-digits-item gm-time-digits-d7"
            >
              <span className="before" style={{ borderWidth: `0 0 ${barWidth}px ${barWidth}px`, top: -barWidth, borderBottomColor: 'inherit' }} />
              <span className="after" style={{ borderWidth: `${barWidth}px 0 0 ${barWidth}px`, bottom: -barWidth, borderTopColor: 'inherit' }} />
            </span>
          </div>
        ))
      }
    </React.Fragment>
  );
}
/**
 * 持续时间
 *
 * @class DurationTime
 * @extends {Component}
 */
class DurationTime extends Component {

  static propTypes = {
    date: PropTypes.string,
    format: PropTypes.string,
    end: PropTypes.bool,
    endTime: PropTypes.string,
    content: PropTypes.func
  };

  static defaultProps = {
    format: 'YYYY-MM-DD HH:mm:ss'
  };

  constructor(props) {
    super(props);
    this.state = {
      runTime: 0
    };
  }

  componentDidMount() {
    this.getStartTime();
  }

  componentDidUpdate(prevProps, prevState) {
    if (prevProps.date !== this.props.date) {
      this.getStartTime();
    }
  }

  componentWillUnmount() {
    this.timer && clearInterval(this.timer);
  }

  start = () => {
    const one = 1000;
    this.timer && clearInterval(this.timer);
    this.timer = setInterval(() => {
      if (this.props.end) {
        this.timer && clearInterval(this.timer);
        return;
      }
      this.setState({ runTime: this.state.runTime + one });
    }, one);
  }

  getStartTime = () => {
    const { date, format, endTime } = this.props;
    if (date) {
      const time = (endTime ? moment(endTime, format) : moment()).diff(moment(date, format));
      this.setState({ runTime: time > 0 ? time : 0 }, () => {
        !endTime && this.start();
      });
    }
  }

  secondToDate = (time) => {
    const timeCovert = 60;
    const onHour = 3600;
    const oneSecends = 1000;
    const onday = 24;
    const days = Math.floor(time / (onday * onHour * oneSecends));
    const leave1 = time % (onday * onHour * oneSecends);
    const hours = Math.floor(leave1 / (onHour * oneSecends));
    const leave2 = leave1 % (onHour * oneSecends);        // 计算小时数后剩余的毫秒数
    const minutes = Math.floor(leave2 / (timeCovert * oneSecends));
    // 计算相差秒数
    const leave3 = leave2 % (timeCovert * oneSecends);      // 计算分钟数后剩余的毫秒数
    const seconds = Math.round(leave3 / oneSecends);


    return [days, hours, minutes, seconds];
  }

  render() {
    const { date, content } = this.props;
    if (!date) {
      return <div />;
    }
    const { runTime } = this.state;
    const [d, h, m, s] = this.secondToDate(runTime);
    if (content) {
      return content(d, h, m, s);
    }

    return (
      <span title={`${h !== '00' ? `${h}时` : ''}${m !== '00' ? `${h}分` : ''}${s}秒`}>
        {!!d && <span>{d}天</span>}
        {!!(d || h) && <span>{h}小时</span>}
        {!!(d || m || h) && <span>{m}分</span>}
        {<span>{s}秒</span>}
      </span>
    );
  }
}

DurationTime.Time = Time;

export default DurationTime;
