import React from 'react';
import { Modal, Button } from 'amos-framework';
import { Message } from 'amos-antd';
import classnames from 'classnames';
import ImageConsts from '@gm/graphmod-assets';
import './tip.scss';

const ghost = Modal.ghost;
/**
 * 提示确认框
 * @param {string} message 提示语
 */
const confirmTip = (message, img, isTip = true) => {
  return new Promise((resolve, reject) => {
    if (isTip){
      const dialog = ghost.show({
        title: '提示',
        className: classnames('mods-com-tip-modal'),
        width: 330,
        content: (
          <div className="mods-com-tip-modal-content">
            <div className="mods-com-tip-modal-img"><img src={img || ImageConsts.common.tip} alt="" /></div>
            <div className="mods-com-tip-modal-msg">{message}</div>
          </div>
        ),
        footer: (
          <div>
            <Button className="mods-com-tip-modal-cancel" onClick={() => dialog.hide()}>
              取消
            </Button>
            <Button
              className="mods-com-tip-modal-ok" onClick={() => {
                resolve();
                dialog.hide();
              }}>
              确定
            </Button>
            <a className="mods-com-tip-modal-close" onClick={() => dialog.hide()} />
          </div>
        )
      });
    } else {
      resolve();
    }
  });
};

/**
 * 提示确认框
 * @param {string} message 提示语
 */
const confirmTipForStation = (message, isTip) => {
  return confirmTip(message, '', isTip);
};

/**
 * 提示确认框 (自定义底部文字)
 * @param {string} message 提示语
 */
const customConfirmTip = (message, img, okTitle, cancelTitle) => {
  return new Promise((resolve, reject) => {
    const dialog = ghost.show({
      title: '提示',
      className: classnames('mods-com-tip-modal'),
      width: 330,
      content: (
        <div className="mods-com-tip-modal-content">
          <div className="mods-com-tip-modal-img"><img src={img || ImageConsts.common.tip} alt="" /></div>
          <div className="mods-com-tip-modal-msg">{message}</div>
        </div>
      ),
      footer: (
        <div>
          <Button
            className="mods-com-tip-modal-cancel" onClick={() => {
              resolve(true);
              dialog.hide();
            }}>
            {okTitle}
          </Button>
          <Button
            className="mods-com-tip-modal-ok" onClick={() => {
              resolve(false);
              dialog.hide();
            }}>
            {cancelTitle}
          </Button>
          <a className="mods-com-tip-modal-close" onClick={() => dialog.hide()} />
        </div>
      )
    });
  });
};

const confirmCheckTip = (message, checkTip, img) => {
  return new Promise((resolve, reject) => {
    Modal.confirm({
      title: '提示',
      className: classnames('eb-tip-modal'),
      width: 275,
      content: (
        <div className="eb-tip-modal-content">
          <div className="eb-tip-modal-img"><img src={img || ImageConsts.common.tip} alt="" /></div>
          <div className="eb-tip-modal-msg">{message}</div>
          <div className="eb-tip-check-input"><input type="checkbox" id="confirmCheckTip" />{checkTip}</div>
        </div>
      ),
      onOk: () => {
        resolve(document.getElementById('confirmCheckTip').checked);
      },
      onCancel() { }
    });
  });
};

Message.config({
  top: 100
  // duration: 1000
});

const Tip = {
  confirm: confirmTip,
  customConfirm: customConfirmTip,
  check: confirmCheckTip,
  confirmTipForStation,
  error: Message.error,
  success: Message.success,
  warning: Message.warning
};

export default Tip;
