import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import FlvJsPlayer from 'xgplayer-flv.js';

class FlvPlay extends Component {
  static propTypes = {
    vedioId: PropTypes.string,
    token: PropTypes.string,
    videoFlag: PropTypes.string,
    liveVideoHost: PropTypes.string,
    noMax: PropTypes.any
  };

  constructor(props) {
    super(props);
    this.fullscreen = false;
  }

  componentDidMount() {
    this.playVedio();
  }

  componentWillUnmount() {
    this.flvPlayer.destroy();
  }


  playVedio = () => {
    const { vedioId,liveVideoHost } = this.props;
    this.reloadFlvPlayer(vedioId, liveVideoHost);
  }

  /**
   * 加载FLV格式视频
   * @param {*} flvUrl
   */
  reloadFlvPlayer = (id,flvUrl) => {
    const { width, height } = this.props;
    if (this.flvPlayer) {
      // 2.有播放器则切换视频源
      this.flvPlayer.src = flvUrl;
      this.flvPlayer.reload();
    } else {
      this.flvPlayer = new FlvJsPlayer({
        id,
        isLive: true,
        playsinline: true,
        url: flvUrl,
        autoplay: this.props.autoFlag === true ? true : false,
        width: width || '100%',
        height: height || '100%',
        cors: true
      });
    }
  };
  render() {
    const { vedioId } = this.props;
    if (vedioId) {
      return (
        <div className={classnames(`mod-com-hikvideo`)} id={vedioId} />
      );
    } else {
      return (
        <div className={classnames(`mod-com-hikvideo`)} >
          <video  width="100%" height="100%" controls="controls" >
            <track kind="captions" />Your browser does not support the video tag.
          </video>
        </div>
      );
    }
  }
}

FlvPlay.propTypes = {
  onFullScreen: PropTypes.func,
  width: PropTypes.string,
  height: PropTypes.string
};

FlvPlay.defaultProps = {
  onFullScreen(){}
};
export default FlvPlay;
