import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { H5sPlayerWS } from './plugins/h5splayer';
import './plugins/adapter';

class Hikvideo extends Component {
  static propTypes = {
    vedioId: PropTypes.string,
    token: PropTypes.string,
    protocol: PropTypes.string,
    liveVideoHost: PropTypes.string,
    noMax: PropTypes.any
  };

  static defaultProps = {
    protocol: 'http'
  }

  constructor(props) {
    super(props);
    this.fullscreen = false;
  }

  componentDidMount() {
    this.playVedio();
  }

  componentWillUnmount() {
    this.disConnect();
  }

  disConnect = () => {
    this.h5handler && this.h5handler.disconnect && this.h5handler.disconnect();
  }

  playVedio = () => {
    const { token, vedioId,liveVideoHost, protocol } = this.props;
    console.log('--->',token, vedioId, liveVideoHost);
    if (vedioId && token && !this.h5handler) {
      // const dom = document.getElementById(vedioId);
      const conf = {
        videoid: vedioId,
        protocol: `${protocol || 'http'}:`, // http: or https:
        host: liveVideoHost, // localhost:8080
        streamprofile: undefined, // {string} - stream profile, main/sub or other predefine transcoding profile
        rootpath: '/',
        token,
        hlsver: 'v1',
        session: null
      };
      this.h5handler = new H5sPlayerWS(conf);
      try {
        this.h5handler.connect();
      } catch (error) {
        console.log(error);
      }
    }
  }
  render() {
    const { vedioId, token } = this.props;
    if (token && vedioId) {
      return (
        <div className={classnames(`mod-com-hikvideo`)}>
          <video
            width="100%"
            height="100%"
            id={vedioId}
            controls="controls"
            autoPlay
            webkit-playsInline
            playsInline
          >
            <track kind="captions" />Your browser does not support the video tag.
          </video>

        </div>
      );
    } else {
      return (
        <div className={classnames(`mod-com-hikvideo`)} >
          <video  autoPlay width="100%" height="100%" controls="controls" >
            <track kind="captions" />Your browser does not support the video tag.
          </video>
        </div>
      );
    }
  }
}

export default Hikvideo;
