/**
 * webpack 打包配置文件
 * @author ilex
 */
const cjsLibConfig = require('amos-build/lib/cjsLibConfig');
const resolveApp = require('amos-build/lib/tools/resolveApp');

module.exports = function cjs(configArgs = {}) {
  // ------------------------------------------------------
  // 添加webpack加载别名,用于导包重定向，优化打包以及代码
  // 此处需要自己进行定义
  // 👻可修改
  // ------------------------------------------------------
  const alias = {};

  // ------------------------------------
  // 入口点
  // ------------------------------------
  const entry = {
    graphmod: './src/index.js'
  };

  const config = {
    outputPath: resolveApp('cjs'),
    alias,
    entry,
    // 启动 WebWorker
    enableWorker: true,
    sourceMap: false,
    ...configArgs
  };

  const defaultConfig = cjsLibConfig(config);

  return defaultConfig;
};
