import * as endConf from 'amos-processor/lib/config/endconf';
import { utils } from 'amos-tool';
import { commonGet, formatUrl, commonPost, formatObjUrl, commonPut, fileDownload } from './request';

const completePrefix = endConf.completePrefix;
const AmosConfig = endConf.AmosConfig;
const baseURI = AmosConfig.httpURI.baseURI;
const fileServerURI = AmosConfig.httpURI.fileServerURI;

export const UrlConsts = {
  getUtilListUrl: url => completePrefix(baseURI, 'iot/v1/iot/IotThingsTemplate/list/property/category'),
  userInfoUrl: url => completePrefix(baseURI, 'privilege/v1/agencyuser/me'), // 根据字典标识获取字典列表 get
  userInfoListUrl: url => completePrefix(baseURI, 'privilege/v1/agencyuser/list/users'), // 获取用户LIST get
  dictListUrl: url => completePrefix(baseURI, 'systemctl/v1/dictionary/{dictCode}/values'), // 根据字典标识获取字典列表 get
  uploadfileUrl: url => completePrefix(baseURI, 'precontrol/file/uploadfile'), // 文件服务器上传接口
  platFormUploadfileUrl: url => completePrefix(baseURI, 'systemctl/v1/filestorage'), // 平台文件服务器上传接口
  lookFileUrl: url => completePrefix('/fileURI/', url), // 查看图片 fileURI需要走转向代理
  departmentListUrl: url => completePrefix(baseURI, 'privilege/v1/department/tree?companySeq={companySeq}'), // 部门列表
  unitListUrl: url => completePrefix(baseURI, 'privilege/v1/company/tree?companyName='), // 单位列表
  designPageUrl: url => completePrefix(baseURI, 'morphic/morphic/scene/{id}'), // 查询画布 get
  companyTree: url => completePrefix(baseURI, 'privilege/v1/company/department/tree'), // 公司部门tree
  roleListUrl: url => completePrefix(baseURI, 'privilege/v1/role/list'), // 角色列表};
  getRegionUrl: url => completePrefix(baseURI, 'systemctl/v1/region/tree'), // 获取行政区划
  ruleDetailsUrl: url => completePrefix(baseURI, 'urule/v1/packageeditor/knowledgepackage/ruleflow/image?project={project}&packageId={packageId}'), // 获取规则详情
  listMaintenanceSpecUrl: url => completePrefix(baseURI, 'urule/v1/packageeditor/loadPackages?project={project}'), // 从规则获取维保规范列表
  administrativeDivisionTreeUrl: () => completePrefix(baseURI, 'systemctl/v1/region/tree/parent'), // 获取全国行政区划树
  accountListUrl: url => completePrefix()('precontrol/safe/unboundUser'), // 账户列表 get
  applicationListUrl: url => completePrefix(baseURI, 'privilege/v1/application/page?current={current}&size={size}&appName='), // 应用列表 get
  permissionListUrl: url => completePrefix(baseURI, 'privilege/v1/permission/list/me?menuAgent=WEB'), // 菜单列表 get
  countByMsgTypesUrl: url => completePrefix(baseURI, 'systemctl/v1/message/countByMsgType/{msgTypes}?terminal=WEB&category=1,2'), // 根据消息类型查询未读数量（1：消息；2系统消息）get
  msgListByMsgTypesUrl: url => completePrefix(baseURI, 'systemctl/v1/message/listByMsgType/{msgTypes}?terminal=WEB&category=1,2'), // 根据消息类型查询消息列表 get
  msgUpdateIsReadUrl: url => completePrefix(baseURI, 'systemctl/v1/message/{sequenceNbr}'), // 修改数据为已读 put
  msgUpdateBatchIsReadUrl: url => completePrefix(baseURI, 'systemctl/v1/message/updateBatch?terminal=WEB'), // 批量修改数据为已读 get
  knowledgeListUrl: (url) => completePrefix(baseURI, 'knowledgebase/v1/doccontent/doclibrary/page?'
    + 'filterByCollection=false&directoryId={directoryId}&offset=0&end=99'),// 知识库列表
  knowledgeContentUrl: (url) => completePrefix(baseURI, 'knowledgebase/v1/doccontent/{id}'),// 知识库详情
  processListUrl: () => completePrefix(baseURI, 'workflow/processDefinition/list/all'), // 获取所有的的流程
  getFlowUrl: () => completePrefix(baseURI, 'workflow/processDefinition/image?processDefinitionId={processDefinitionId}'), // 根据流程实例id获取流程图 get
  remoteUrl: completePrefix(baseURI, 'morphic/biz/url'), // 请求第三方系统 api， post，需要传入第三方api 地址
  generateSqlUrl: url => completePrefix(baseURI, 'studio/v1/dataApi/generateSQL') // 通用导出SQL脚本 get
};
/**
 * 根据字典标识获取字典列表
 */
export const dictAction = dictCode => {
  return commonGet(formatUrl(UrlConsts.dictListUrl(), { dictCode }));
};

/**
 * 获取用户信息
 */
export const userInfoAction = () => {
  return commonGet(UrlConsts.userInfoUrl());
};

/**
 * 获取用户信息list
 */
export const userInfoListUrl = () => {
  return commonGet(UrlConsts.userInfoListUrl());
};
/**
 * 文件上传
 * @param {*} file  file对象
 */
export const fileUploadAction = file => {
  const formData = new window.FormData();
  formData.append('file', file);
  return commonPost(UrlConsts.platFormUploadfileUrl(), formData);
};

/**
 * 图片文件路径补全
 * @param {string} fileUrl
 */
export const filePrefixUrl = fileUrl => completePrefix(fileServerURI, fileUrl);
/**
 * 获取部门列表
 */
export const departmentListAction = companySeq => {
  return commonGet(formatUrl(UrlConsts.departmentListUrl(), { companySeq }));
};
/**
 * 获取角色列表
 */
export const roleListAction = () => {
  return commonGet(UrlConsts.roleListUrl());
};
/**
 * 获取角色列表
 */
export const unitListAction = () => {
  return commonGet(UrlConsts.unitListUrl());
};

/**
 * 获取画布详情
 */
export const designPageAction = id => {
  return commonGet(formatUrl(UrlConsts.designPageUrl(), { id }));
};

export const utilListAction = () => {
  return commonGet(UrlConsts.getUtilListUrl());
};
/**
 * 公司部门tree
 */
export const companyTree = () => {
  return commonGet(UrlConsts.companyTree());
};

/**
 * 获取行政区划
 */
export const getRegion = () => {
  return commonGet(formatUrl(UrlConsts.getRegionUrl()));
};

/**
 * 获取规范列表
 */
export const listMaintenanceSpec = project => {
  return commonGet(formatUrl(UrlConsts.listMaintenanceSpecUrl(), { project }));
};
/**
 * 获取规则详情
 */
export const ruleDetailsAction = (project, packageId) => {
  return commonGet(formatUrl(UrlConsts.ruleDetailsUrl(), { project, packageId }));
};

export const administrativeDivisionTreeAction = () => {
  return commonGet(UrlConsts.administrativeDivisionTreeUrl());
};

// 获取账户列表
export const accountListAction = data => {
  return commonGet(UrlConsts.accountListUrl(), data);
};

// 获取应用列表
export const applicationListAction = (data) => {
  return commonGet(formatUrl(UrlConsts.applicationListUrl(), data));
};

// 获取菜单列表
export const permissionListAction = () => {
  return commonGet(UrlConsts.permissionListUrl());
};

/**
 * 根据消息类型查询未读数量
 */
export const countByMsgTypesAction = (msgTypes) => {
  return commonGet(formatUrl(UrlConsts.countByMsgTypesUrl(), { msgTypes }));
};

/**
 * 根据消息类型查询消息列表
 */
export const msgListByMsgTypesAction = (msgTypes, filter) => {
  return commonGet(formatObjUrl({ url: formatUrl(UrlConsts.msgListByMsgTypesUrl(), { msgTypes }), filter }));
};

/**
 * 修改数据为已读
 */
export const msgUpdateIsReadAction = (sequenceNbr) => {
  return commonPut(formatUrl(UrlConsts.msgUpdateIsReadUrl(), { sequenceNbr }));
};

/**
 * 批量修改数据为已读
 */
export const msgUpdateBatchIsReadAction = () => {
  return commonGet(UrlConsts.msgUpdateBatchIsReadUrl());
};

/**
 * 知识库列表
 */
export const knowledgeListAction = (directoryId = '') => {
  return commonGet(formatUrl(UrlConsts.knowledgeListUrl(), { directoryId }));
};

/**
 * 知识库详情
 */
export const knowledgeContentAction = (id) => {
  return commonGet(formatUrl(UrlConsts.knowledgeContentUrl(), { id }));
};

/**
 * 获取所有的工作流
 * @returns
 */
export const processListAction = () => {
  return commonGet(UrlConsts.processListUrl());
};

/**
 * 获取流程图
 * @param {*} processDefinitionId 流程id
 * @returns
 */
export const getFlowImgAction = (processDefinitionId) => {
  return commonGet(formatUrl(UrlConsts.getFlowUrl(), { processDefinitionId }));
};

/**
 * 图片文件路径补全
 * @param {string} url
 */
export const filePrefixUrl2 = url => {
  const prefix = fileServerURI === '/' ? '' : fileServerURI;
  const tempUrl = prefix + url;
  return utils.isUrl(url) ? url : tempUrl;
};

/**
 * 通用请求
 */
export const invokeRemoteApi = (data) => {
  return commonPost(UrlConsts.remoteUrl, data);
};

/**
 * 通用导出SQL脚本
 */
export const templateDownload = (params) => {
  return fileDownload({ url: formatObjUrl({ url: UrlConsts.generateSqlUrl(), filter: params }) });
};
