import * as endConf from 'amos-processor/lib/config/endconf';
import { commonPost, commonGet, sso } from 'amos-designer';

const { encodePassword } = sso;
const completePrefix = endConf.completePrefix;
const AmosConfig = endConf.AmosConfig;
const baseURI = AmosConfig.httpURI.baseURI;

export const secExtUrl = {
  oauth2Url: completePrefix(baseURI, 'privilege/v1/auth/idpassword'), // post
  amosApplicationListUrl: completePrefix(baseURI, 'privilege/v1/application/list/user/plateform'), // 获取当前用户的amos平台授权的应用列表 get
  applicationListUrl: completePrefix(baseURI, 'privilege/v1/application/list/user/agency'), // 获取当前用户的机构自身的应用列表 get
  agencyAllApplicationListUrl: completePrefix(baseURI, 'privilege/v1/application/list/agency'), // 当前机构的所有应用集合 get
  userApplicationListUrl: completePrefix(baseURI, 'privilege/v1/application/list/user/service') // 获取当前用户的机构自身的应用列表 get
};

/**
 * 登录
 * @param {*} data
 */
export const loginAction = (data) => {
  const newData = encodePassword(data);
  return commonPost(secExtUrl.oauth2Url, newData);
};

/**
 * 获取当前用户的机构自身的应用列表
 */
export const accessAction = () => {
  return commonGet(secExtUrl.userApplicationListUrl);
};
