# description

该目录下，存放所有的 pkg 业务组件

## example 说明

每一个业务组件中，如果具备 example 目录，则直接在 example 中写上该业务组件的所有测试用例

## 模块包目录说明

- `graphmod-assets` 业务组件库通用资源文件库
- `graphmod-common` 业务组件库公共组件包
- `graphmod-scripts` 公共启动脚本库，用于快速创建 `dev、sdk` 启动脚本
- `graphmod-utils` 公共工具组件库
- `graphmod-knowledge` 知识库业务组件库

## 新增 mod 模块方式

创建步骤：

1. 复制 `_graphmod-demo` 同时重命名，修改名称，均以 `graphmod-xxx` 的格式
2. 修改 `package.json` 中的 name 字段，修改为 `@gm/你的文件夹名称`， 如 `@gm/graphmod-help`， 删除 `private` 字段
3. 所有的工程，均依赖于 `@gm/graphmod-scripts|utils|assets|common`
4. `src` 目录为源码目录
5. `example` 目录为测试用例目录
6. `__tests__` 目录为单元测试目录
7. 项目的启动与打包，均需要在根木路进行执行，也可以在当前目录执行，但是需要重新独立安装依赖（不推荐当前目录执行脚本命令）。
8. 在根目录的 `package.json` 中添加诸如 `start:gk、build:gk` 命令即可。
9. 执行方式根目录执行 `npm run start:gk` 进行开发模式下测试， `npm run build:gk` 进行sdk打包。

## 新增 mod 模块中关键信息说明

### 业务应用全局配置config.json, 类似于平台的amos.config.js
1. packages目录下所有的子项目下包含config.json文件，此文件为子项目的简单信息的全局配置
2. config.json 为简单的对象类型， 代理中引用方式window.gmconfig.XXX
3. 打包时注意config.json的引用，在website/src/config.js中configs数组中根据项目对应的子项目引用对应的config.json,打包成功后会将对应的json自动放到包里面，发布是配置成生产环境的信息即可。
