/**
 * webpack 打包配置文件
 * @author ilex
 */
const umdConfig = require('amos-build/lib/umdConfig');
const AssignUMDRoot = require('amos-build/lib/plugins/AssignUMDRoot');
const resolveCwd = require('amos-build/lib/tools/resolveCwd');
const removeFile = require('amos-build/lib/tools/removeFile');

// ------------------------------------
// 入口点
// ------------------------------------
const entry = {
  // graphmod: './src/index.js'
  // graphmod: './src/station.js'
  // graphmod: './src/jcs119.js'
  graphmod: './src/jcs.js'
};
const vname = 'lib/jcs_v1.0.0.0';
// const vname = 'lib/jcs_119_v1.0.0.0';
/**
 * 创建 sdk 编译脚本
 * @param {String} vname 项目版本名称，打包完成后会生成对应的文件夹名称，生成文件夹名称不能手动修改
 * @returns {}
 */
function sdk(vn = 'lib', configArgs = {}) {
  // 先删除已有版本
  // 采用版本管理每次发布，如果版本号不变，则无需删除指定版本
  removeFile(vn);

  // ------------------------------------------------------
  // 添加webpack加载别名,用于导包重定向，优化打包以及代码
  // 此处需要自己进行定义
  // 👻可修改
  // ------------------------------------------------------
  const alias = {};

  const config = {
    entry,
    outputPath: resolveCwd(vn), // 如果使用版本管理，此处改为 resolveApp(vn)
    filename: '[name].js',
    library: 'globalmod',
    libraryTarget: 'umd',
    libraryExport: 'default',
    alias,
    // 启动 WebWorker
    enableWorker: true,
    sourceMap: false,
    // 确保生成均在 body 上的 split 代码
    htmlPluginConfig: {
      // 'blocking'|'defer', 设置 blocking 让其添加在 body 上
      scriptLoading: 'blocking'
    },
    enableSplit: true,
    ...configArgs
  };

  const defaultConfig = umdConfig(config);

  defaultConfig.output.publicPath = '';

  // 合并相同的 globalmod
  defaultConfig.plugins.push(new AssignUMDRoot());

  return defaultConfig;
}

module.exports = sdk(vname);
