# mod 说明

组态、混合设计器通用 mod 工程。

## 开发&测试

执行：

```bash
npm run build-mod
```

会在 `lib` 目录生成 `graphmod`,修改 `example/sketch.js` 中 mods 来源即可。

可以将该 `js` 文件拷贝至其它系统，直接使用。

该模式下，默认通过 `package.json` 中的 `version` 字段创建版本目录，如果版本号不变，则更新当前版本。

在开发模式下发布版本，每次只允许修改最后一个版本号，如 `1.0.0` 改为 `1.0.1`。同时将该版本推送至 `prod` 分支。

`prod` 分支中，仅允许的文件：

```conf
- lib
- package.json
- .gitignore
- readme.md
```

## 发布 example 内容

执行：

```bash
npm run build-exp
```

会在 `dist` 目录生成当前 example 测试使用的案例。该目录下，可以直接发布至 nginx 作为一个系统使用

## 发布

执行:

```bash
npm run pub
```

将会将编译好的 mod 发布至 npm 私服。

## 如何解决多团队开发各自业务组件冲突问题 `？`

- 方式一：各团队自行管理自己的发布版本，在 `studio` 平台中，引入不同的发布版本。studio 中所有的业务组件版本都要进行保存, `studio` 创建工程时可采用指定版本。

- 方式二：独立管理各团队的业务组件，每次发布的时候，发布各自业务组件，采用 `npm 私服` 管理各个依赖版本，`graphmod` 核心再引入各自版本。studio 中只引入 `graphmod` 核心。这样可以确保 `graphmod` 中，始终是完善的业务组件, 但无法解决不同业务组件版本共存问题。

- 方式三：采用 `git` 特定分支的方式，管理版本发布，在该分支上，存放所有完整的已发布业务组件。与方式二的效果相同，可以节省 `npm 私服` 管理成本。

### 方式三管理版本具体操作

- 步骤一：拆分集中式 `graphmod` 开发, 采用 [lerna](https://lerna.js.org/) 同仓库不同包管理源码。（lerna 非必须）
- 步骤二：拆分完毕之后的源码，通过控制 `子业务组件` 的版本来确保是否更新依赖
- 步骤三：在核心 `graphmod` 中进行统一业务组件打包 `npm run build-mod`，将打包后的代码推送到指定分支即可。
- 步骤四：在 `studio` 中引入该分支，同时在 `.amosrun.config.js` 中配置 `dirs`，执行拷贝指定版本。

> 附录：使用 `git` 源作为 `npm` 包仓库源。

以 `amos-iot-graphmod` master 分支作为示例：

```json
{
  "dependencies": {
    "amos-iot-graphmod": "git+http://amospkg:public123@172.16.10.76/iotgraph/amos-iot-graphmod#master"
  }
}
```

`studio` 中 `.amosrun.config.js` 添加代码示例：

```js
module.exports = {
  ...
  dirs: [
    ...
    { fromDir: 'amos-iot-graphmod/released/**', toDir: 'released/external/'},
    ...
  ],
  ...
};
```

其中 `amospkg/public123` 是公共用户，该用户仅作为下载 `git` 依赖使用

## umd 启动 split code 加载

> 或者设置 `window.__mod_baseURL__ = '/external/studio/'` 路径，直接在 html 页面引入 `mod-scripts.js`
> 或者采用 installWorker 实现

```js
// 需要引入 sdkroot 的项目，直接在 entry 中进行子线程加载 mod 包

import { PubSub } from 'ray-eventpool';
import installWorker from 'amos-designer/lib/worker/installWorker';

// 测试加载 worker
installWorker({
  baseUrl: '/mod/',
  scriptUrl: 'scripts.json',
  useBody: true,
  // 所有的脚本加载完毕
  onDone(){
    const globalmod = window.globalmod || {};
  }
});
```

> 第三方引入

```js
import loadModScripts from 'amos-designer/lib/utils/loadModScripts';

// 测试加载 worker
loadModScripts({
  baseUrl: '/mod/',
  scriptUrl: 'scripts.json',
  useBody: true,
  // 所有的脚本加载完毕
  onDone(){
    const globalmod = window.globalmod || {};
  }
});
```

## 新版本 lerna 管理启动方式

先全局安装 `lerna`, 使用 `lerna v3.22.1`

```bash
npm i -g lerna@3.22.1
```

启动本地项目：

```bash
# 安装依赖
npm run i:root
# 软链接
npm run link
# 启动子模块，以知识库为例
npm run start:gk
```

多个命令合并：

> 无需单个执行删除、安装依赖、软链接。只需要执行 reset 即可。
> windows 环境下直接双击 `reset.bat` 即可

```bash
npm run reset
```

## website 目录说明

该目录仅作为各自项目发布目录，该目录下，可以将 packages 中的不同模块进行组合集成，该模块发布，默认启用 mf。

每一个项目，创建一个项目 `entry.js` 文件，只需要在 `webpack.config.sdk.js` 中，修改entry 中的路径即可。

```bash
# 直接在 website 中创建 sdk
npm run build:sdk
# 启用 mf 创建 sdk 包
npm run build:sdkmf
```

## 其它

umd 或 mf 公共模块，可以在启动的时候，直接使用平台的 umd 和 mf 模块
