// 该模块存放系统通用 api 接口
// 各自模块的 api 存放在自己模块根目录下
import * as endConf from 'amos-processor/lib/config/endconf';

import { request, gateWay } from '@gm/graphmod-utils';

const completePrefix = endConf.completePrefix;
const AmosConfig = endConf.AmosConfig;
const baseURI = AmosConfig.httpURI.baseURI;

const {
  commonGet,
  commonPost,
  commonPut,
  formatUrl,
  commonDelete,
  formatObjUrl,
  fileDownload
} = request;


export const UrlConsts = {
  deleteAgency: (url) => completePrefix(baseURI, 'jcs/Agency/relation/{agencyCodeId}/{sequenceNbrs}'),
};

/**
 * 删除机构
 */
export const deleteByAgencyCode = ( agencyCodeId, sequenceNbrs) => {
  console.log(formatUrl(UrlConsts.deleteAgency(), { agencyCodeId, sequenceNbrs }))
  return commonDelete(formatUrl(UrlConsts.deleteAgency(), { agencyCodeId, sequenceNbrs }));
};

