import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { BarGroup, IconButton, briskWarningTip } from 'amos-designer';
import * as api from '../api';
import { connectGlobalPage } from '@gm/graphmod-common';
import ExecuteProgress from './ExecuteProgress';
import DeleteModel from './DeleteModel';

const { deleteByAgencyCode } = api;

/**
 * 导出sql脚本模块
 * @class DeleteView
 * @extends {Component}
 */

// @connectGlobalPage({
//   testDataConfig: {
//     resourceCode: 'StudioApplication', // 标识
//     dimension: 'appSeq', // 字段
//     appSeq: '1620614032232841218',
//     mqttUrl: 'ws://172.16.3.18:8088/mqtt',
//     position:'header'
//   }
// })

@connectGlobalPage({
  testDataConfig: {
    agencyCodeId: '1397143491787747330',//机构ID
    sequenceNbrs: '1676795341917782033,1676795341917782024',//数据库连接sequenceNbrs
    mqttUrl: 'ws://172.16.3.18:8088/mqtt'
  }
})


class DeleteView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      downloadVisible: false,
      logsVisible: false,
      selectId: ''
    };
  }

  handleClose = (key) => {
    this.setState({
      [key]: false
    });
  };

  handleOpen = (key) => {
    this.setState({
      [key]: true
    });
  };

  handleItemClick = () => {
    const { selectedRowKeys = [], dataConfig, record } = this.props;
    if (selectedRowKeys.length > 0 || record) {
      this.setState({ selectId: selectedRowKeys.length === 0 ? record.id ?? record.sequenceNbr : '', logsVisible: true }, () => {
        if (dataConfig.sequenceNbrs && (selectedRowKeys.length > 0 || record)) {
          dataConfig[dataConfig.sequenceNbrs] = (record ? record.id ?? record.sequenceNbr : null) || selectedRowKeys.join(',');
          deleteByAgencyCode({ agencyCodeId: dataConfig.agencyCodeId, sequenceNbrs: dataConfig.sequenceNbrs });
        }
      });
    } else {
      briskWarningTip('至少选择一个数据库和一个机构');
    }

    // const { selectedRowKeys = [], dataConfig, record } = this.props;
    // if (selectedRowKeys.length === 0 ) {
    //   this.setState({ selectId: dataConfig.sequenceNbrs, logsVisible: true }, () => {
    //       deleteByAgencyCode( dataConfig.agencyCodeId, dataConfig.sequenceNbrs );
    //   });
    // } else {
    //   briskWarningTip('至少选择一个数据库');
    // }
    
    // debugger
    // const { selectedRowKeys = [], dataConfig, record } = this.props;
    // if (selectedRowKeys.length > 0 || record) {
    //   this.setState({ selectId: selectedRowKeys.length === 0 ? record.id ?? record.sequenceNbr  : selectedRowKeys[0], logsVisible: true }, () => {
    //     if (dataConfig.dimension && (selectedRowKeys.length > 0 || record)) {
    //       dataConfig[dataConfig.dimension] = (record ? record.id ?? record.sequenceNbr : null) || selectedRowKeys.join(',');
    //       templateDownload({ resourceCode: dataConfig.resourceCode, dimension: dataConfig.dimension, [dataConfig.dimension]: dataConfig[dataConfig.dimension] });
    //     }
    //   });
    // } else {
    //   briskWarningTip('至少选择一行数据');
    // }
  };

  render() {
    const { dataConfig = {} } = this.props;
    const { logsVisible, selectId, downloadVisible } = this.state;
    return (
      <div>
        {dataConfig.position === 'header' ?
          <div className="ig-stage-toolbar-right">
            <BarGroup label="导出脚本" mode="none" position="right">
              <IconButton colorful icon="export" title="导出SQL脚本" style={{ borderRadius: 4 }} onClick={() => this.handleItemClick()} />
            </BarGroup>
          </div>
          :
          <p onClick={this.handleItemClick}>删除</p>
        }
        <DeleteModel
          visible={this.downloadVisible}
          onClose={() => this.handleClose('downloadVisible')}
          handleOpen={() => this.handleOpen()}
          dataConfig={dataConfig}
        />
        <ExecuteProgress visible={logsVisible} mqttUrl={dataConfig.mqttUrl} exeId={selectId}  onClose={() => this.handleClose('logsVisible')} />
      </div>
    );
  }
}

DeleteView.propTypes = {
  selectedRowKeys: PropTypes.array,
  dataConfig: PropTypes.object,
  record: PropTypes.object
};

export default DeleteView;
