// 根据不同项目引用不同子项目的config.json配置
const configs = [
  // { name: 'team', source: 'packages/graphmod-team/config.json' }
];

// 加载配置
function initConfig() {
  window.gmconfig = {};
  configs.forEach(e => {
    const version = window.hybridModular.version || '';
    const prefix = version.includes('/') ? version : `/external/graphmod/${version}`;
    fetch(`${prefix}/${e.name}.config.json`)
      .then(respone => respone.json())
      .then(d => {
        window.gmconfig = { ...window.gmconfig, ...d || {} };
      });
  });
}

module.exports = {
  configs,
  initConfig
};
