import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Tabs, Row, Col, Input, Radio, Button, Modal } from 'amos-antd';

import { Scrollbars } from 'amos-framework';

import './index.scss';

const TabPane = Tabs.TabPane;
const RadioGroup = Radio.Group;

// 計算公式
class FormulaCalculate extends Component {
  static propTypes = {
    visible: Boolean,
    handleOk: Function,
    onCancel: PropTypes.func
  };

  constructor(props) {
    super(props);

    this.state = {
      v2: 0.01,
      a2: 0.99,
      g2: 1
      // visible: false,
    };
  }
  componentDidMount() {}

  onReset1 = () => {
    this.setState({
      v1: '',
      v2: 0.01,
      v3: '',
      v4: '',
      v5: '',
      v6: '',
      v7: '',
      v8: '',
      v9: '',
      v10: '',
      v11: ''
    });
  };

  onReset2 = () => {
    this.setState({
      a1: '',
      a2: 0.99,
      a3: '',
      a4: '',
      a5: '',
      a6: ''
    });
  };

  onReset3 = () => {
    this.setState({
      b1: '',
      b2: '',
      b3: '',
      b4: '',
      b5: '',
      b6: ''
    });
  };

  onReset4 = () => {
    this.setState({
      c1: '',
      c2: '',
      c3: '',
      c4: '',
      c5: '',
      c6: ''
    });
  };

  onReset5 = () => {
    this.setState({
      d1: '',
      d2: '',
      d3: '',
      d4: '',
      d5: '',
      d6: ''
    });
  };

  onReset6 = () => {
    this.setState({
      e1: '',
      e2: '',
      e3: '',
      e4: '',
      e5: '',
      e6: ''
    });
  };

  onReset7 = () => {
    this.setState({
      f1: '',
      f2: '',
      f3: '',
      f4: ''
    });
  };

  onReset8 = () => {
    this.setState({
      g1: '',
      g2: 1,
      g3: '',
      g4: '',
      g5: ''
    });
  };

  onChange1 = e => {
    this.setState({
      v2: e.target.value
    });
  };

  onChange2 = e => {
    this.setState({
      a2: e.target.value
    });
  };

  onChange4 = e => {
    this.setState({
      g2: e.target.value
    });
  };

  callback = key => {
    console.log(key);
  };

  onChangeValue = e => {
    this.setState({
      [e.target.name]: e.target.value
    });
  };

  onClicka = () => {
    let { a1, a2, a3, a4 } = this.state;
    const num = 60;
    const num1 = 1000;
    let result1 = (a1 * a2 * a3).toFixed(2);
    let result2 = (a1 * a2 * a3 * a4 * num).toFixed(2);
    result2 = (result2 / num1).toFixed(2);
    this.setState({
      a5: result1,
      a6: result2
    });
  };

  onClickb = () => {
    let { b1, b2, b3, b4 } = this.state;
    const num = 3600;
    const num1 = 1000;
    let result1 = (Math.PI * b1 * b2 * b3).toFixed(2);
    let result2 = (Math.PI * b1 * b2 * b3 * b4 * num).toFixed(2);
    result2 = (result2 / num1).toFixed(2);
    this.setState({
      b5: result1,
      b6: result2
    });
  };

  onClickc = () => {
    let { c1, c2, c3, c4 } = this.state;
    const num = 0.5;
    const num1 = 3600;
    const num2 = 1000;
    let result1 = (Math.PI * c1 * c2 * c3 * num).toFixed(2);
    let result2 = (Math.PI * c1 * c2 * c3 * c4 * num1 * num).toFixed(2);
    result2 = (result2 / num2).toFixed(2);
    this.setState({
      c5: result1,
      c6: result2
    });
  };

  onClickd = () => {
    let { d1, d2, d3, d4 } = this.state;
    // const num = 0.5;
    const num1 = 3600;
    const num2 = 1000;
    let result1 = (Math.PI * d1 * d2 * d3).toFixed(2);
    let result2 = (Math.PI * d1 * d2 * d3 * d4 * num1).toFixed(2);
    result2 = (result2 / num2).toFixed(2);
    this.setState({
      d5: result1,
      d6: result2
    });
  };

  onClicke = () => {
    let { e1, e2, e3, e4 } = this.state;
    const num = 0.5;
    const num1 = 3600;
    const num2 = 1000;
    let result1 = (Math.PI * e1 * e2 * e3 * num).toFixed(2);
    let result2 = (Math.PI * e1 * e2 * e3 * e4 * num1 * num).toFixed(2);
    result2 = (result2 / num2).toFixed(2);
    this.setState({
      e5: result1,
      e6: result2
    });
  };

  onClickf = () => {
    let { f1, f2 } = this.state;
    const num = 1000;
    let c = num;
    let result1 = Math.ceil(c / f1);
    let result2 = Math.ceil(c / f2);
    this.setState({
      f3: result1,
      f4: result2
    });
  };

  onClickg = () => {
    let { g1, g2, g3 } = this.state;
    const num = 0.0008;
    let result1 = (g1 * g1 * num * g2).toFixed(2);
    let result = (g1 * g1 * num * g2).toFixed(2);
    let result2 = Math.ceil(result / g3);
    this.setState({
      g4: result1,
      g5: result2
    });
  };

  onClickv = () => {
    let { v1, v2, v3, v4, v5, v6, v7 } = this.state;
    const num = 60;
    const num1 = 1000;
    if (!v1 || !v2 || !v3 || !v4 || !v5 || !v6 || !v7) {
      return;
    }
    let result1 = (v1 * v2 * v3 * v4 * num).toFixed(2);
    result1 = (result1 / num1).toFixed(2);
    let result2 = Math.ceil((v1 * v3) / v5);
    let result3 = Math.ceil((v1 * v3) / v6);
    let result4 = Math.ceil((v1 * v3) / v7);
    this.setState({
      v8: result1,
      v9: result2,
      v10: result3,
      v11: result4
    });
  };

  render() {
    return (
      <Modal
        title="计算公式"
        className="szzh-model"
        width={1000}
        visible={this.props.visible}
        onOk={this.props.handleOk}
        onCancel={this.props.onCancel}
        footer={null}
      >
        <div className="szzh-formula-calculate-all-css">
          <Tabs onChange={this.callback} size="small">
            <TabPane tab="泡沫原液量" key="1">
              <Scrollbars>
                <div style={{ height: '100%', padding: '0 15px' }}>
                  <div className="szzh-formula-calculate-content-css">
                    <div className="szzh-disaster-right-title-css">计算参数</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs">泡沫混合液供给强度</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="v1" onChange={this.onChangeValue} value={this.state.v1} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          L/s·m²
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs">泡沫混合比</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <RadioGroup name="v2" onChange={this.onChange1} value={this.state.v2}>
                          <Radio value={0.01}>1%</Radio>

                          <Radio value={0.02}>2%</Radio>

                          <Radio value={0.06}>6%</Radio>
                        </RadioGroup>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs">液体燃烧面积</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="v3" onChange={this.onChangeValue} value={this.state.v3} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          L/s·m²
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs">供液时间</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="v4" onChange={this.onChangeValue} value={this.state.v4} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          分钟
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs">泡沫枪型号</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="v5" onChange={this.onChangeValue} value={this.state.v5} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          PQ4
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs">泡沫液流量</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="v6" onChange={this.onChangeValue} value={this.state.v6} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          L/s
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs">泡沫钩管流量</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="v7" onChange={this.onChangeValue} value={this.state.v7} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          L/s
                        </span>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-divider-css" />

                  <div className="szzh-formula-calculate-button-css">
                    <Button size="small" onClick={this.onClickv}>
                      计算
                    </Button>

                    <Button size="small" className="szzh-buttonStyle" onClick={this.onReset1}>
                      重置
                    </Button>
                  </div>

                  <div className="szzh-formula-calculate-bottom-css">
                    <div className="szzh-disaster-right-title-css">计算结果</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">需泡沫原液量(t)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.v8}</span>
                          </Col>
                        </Row>
                      </Col>

                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">需泡沫枪数量(支)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.v9}</span>
                          </Col>
                        </Row>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">需泡沫炮数量(门)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.v10}</span>
                          </Col>
                        </Row>
                      </Col>

                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">需泡沫枪数量(架)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.v11}</span>
                          </Col>
                        </Row>
                      </Col>
                    </Row>
                  </div>
                </div>
              </Scrollbars>
            </TabPane>

            <TabPane tab="立罐灭火冷却用水量" key="2">
              <Scrollbars>
                <div style={{ height: '100%', padding: '0 15px' }}>
                  <div className="szzh-formula-calculate-content-css">
                    <div className="szzh-disaster-right-title-css">配置泡沫用水量计算参数</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">泡沫混合液供给强度</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="a1" onChange={this.onChangeValue} value={this.state.a1} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          L/s·m²
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">泡沫混合液含水率</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <RadioGroup name="a2" onChange={this.onChange2} value={this.state.a2}>
                          <Radio value={0.99}>99%</Radio>

                          <Radio value={0.97}>97%</Radio>

                          <Radio value={0.94}>94%</Radio>
                        </RadioGroup>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">液体燃烧面积</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="a3" onChange={this.onChangeValue} value={this.state.a3} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          m²
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">供液时间</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="a4" onChange={this.onChangeValue} value={this.state.a4} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          分钟
                        </span>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-button-css">
                    <Button size="small" onClick={this.onClicka}>
                      计算
                    </Button>

                    <Button size="small" className="szzh-buttonStyle" onClick={this.onReset2}>
                      重置
                    </Button>
                  </div>

                  <div className="szzh-formula-calculate-bottom-css">
                    <div className="szzh-disaster-right-title-css ">计算结果</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">配置泡沫用水流量(L/s)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.a5}</span>
                          </Col>
                        </Row>
                      </Col>

                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">配置泡沫用水量(t)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.a6}</span>
                          </Col>
                        </Row>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-divider-css" />

                  <div className="szzh-formula-calculate-content-css">
                    <div className="szzh-disaster-right-title-css">着火罐冷却用水量计算参数</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">着火罐直径</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="b1" onChange={this.onChangeValue} value={this.state.b1} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          m
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">着火罐冷却水供给强度</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="b2" onChange={this.onChangeValue} value={this.state.b2} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          L/s*m
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">着火罐数量</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="b3" onChange={this.onChangeValue} value={this.state.b3} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          个
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs szzh-itemLabel">冷却持续时间</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="b4" onChange={this.onChangeValue} value={this.state.b4} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          小时
                        </span>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-button-css">
                    <Button size="small" onClick={this.onClickb}>
                      计算
                    </Button>

                    <Button size="small" className="szzh-buttonStyle" onClick={this.onReset3}>
                      重置
                    </Button>
                  </div>

                  <div className="szzh-formula-calculate-bottom-css">
                    <div className="szzh-disaster-right-title-css">计算结果</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">着火罐冷却用水流量(L/s)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.b5}</span>
                          </Col>
                        </Row>
                      </Col>

                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">着火罐冷却用水量(t)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.b6}</span>
                          </Col>
                        </Row>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-divider-css" />

                  <div className="szzh-formula-calculate-content-css">
                    <div className="szzh-disaster-right-title-css">冷近罐冷却用水量计算参数</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">冷近罐直径</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="c1" onChange={this.onChangeValue} value={this.state.c1} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          m
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">冷近罐冷却水供给强度</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="c2" onChange={this.onChangeValue} value={this.state.c2} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          L/s*m
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">冷近罐数量</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="c3" onChange={this.onChangeValue} value={this.state.c3} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          个
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs szzh-itemLabel">冷却持续时间</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="c4" onChange={this.onChangeValue} value={this.state.c4} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          小时
                        </span>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-button-css">
                    <Button size="small" onClick={this.onClickc}>
                      计算
                    </Button>

                    <Button size="small" className="szzh-buttonStyle" onClick={this.onReset4}>
                      重置
                    </Button>
                  </div>

                  <div className="szzh-formula-calculate-bottom-css">
                    <div className="szzh-disaster-right-title-css">计算结果</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">冷近罐冷却用水流量(L/s)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.c5}</span>
                          </Col>
                        </Row>
                      </Col>

                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">冷近罐冷却用水量(t)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.c6}</span>
                          </Col>
                        </Row>
                      </Col>
                    </Row>
                  </div>
                </div>
              </Scrollbars>
            </TabPane>

            <TabPane tab="液化烃球罐冷却用水量" key="3">
              <Scrollbars>
                <div style={{ height: '100%', padding: '0 15px' }}>
                  <div className="szzh-formula-calculate-content-css">
                    <div className="szzh-disaster-right-title-css">着火罐冷却用水量计算参数</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">着火罐直径</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="d1" onChange={this.onChangeValue} value={this.state.d1} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          m
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">着火罐冷却水供给强度</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="d2" onChange={this.onChangeValue} value={this.state.d2} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          L/s*m
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">着火罐数量</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="d3" onChange={this.onChangeValue} value={this.state.d3} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          个
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">冷却持续时间</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="d4" onChange={this.onChangeValue} value={this.state.d4} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          小时
                        </span>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-button-css">
                    <Button size="small" onClick={this.onClickd}>
                      计算
                    </Button>

                    <Button size="small" className="szzh-buttonStyle" onClick={this.onReset5}>
                      重置
                    </Button>
                  </div>

                  <div className="szzh-formula-calculate-bottom-css">
                    <div className="szzh-disaster-right-title-css">计算结果</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">着火罐冷却用水流量(L/s)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.d5}</span>
                          </Col>
                        </Row>
                      </Col>

                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">着火罐冷却用水量(t)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.d6}</span>
                          </Col>
                        </Row>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-divider-css" />

                  <div className="szzh-formula-calculate-content-css">
                    <div className="szzh-disaster-right-title-css">冷近罐冷却用水量计算参数</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">冷近罐直径</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="e1" onChange={this.onChangeValue} value={this.state.e1} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          m
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">冷近罐冷却水供给强度</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="e2" onChange={this.onChangeValue} value={this.state.e2} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          L/s*m
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">冷近罐数量</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="e3" onChange={this.onChangeValue} value={this.state.e3} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          个
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">冷却持续时间</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="e4" onChange={this.onChangeValue} value={this.state.e4} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          小时
                        </span>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-button-css">
                    <Button size="small" onClick={this.onClicke}>
                      计算
                    </Button>

                    <Button size="small" className="szzh-buttonStyle" onClick={this.onReset6}>
                      重置
                    </Button>
                  </div>

                  <div className="szzh-formula-calculate-bottom-css">
                    <div className="szzh-disaster-right-title-css">计算结果</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">冷近罐冷却用水流量(L/s)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.e5}</span>
                          </Col>
                        </Row>
                      </Col>

                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">冷近罐冷却用水量(t)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.e6}</span>
                          </Col>
                        </Row>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-divider-css" />

                  <div className="szzh-formula-calculate-content-css">
                    <div className="szzh-disaster-right-title-css">冷却枪炮数量计算参数</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">水枪流量</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="f1" onChange={this.onChangeValue} value={this.state.f1} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          m
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">移动炮流量</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="f2" onChange={this.onChangeValue} value={this.state.f2} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          m
                        </span>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-button-css">
                    <Button size="small" onClick={this.onClickf}>
                      计算
                    </Button>

                    <Button size="small" className="szzh-buttonStyle" onClick={this.onReset7}>
                      重置
                    </Button>
                  </div>

                  <div className="szzh-formula-calculate-bottom-css">
                    <div className="szzh-disaster-right-title-css">计算结果</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">冷却水枪数量(支)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.f3}</span>
                          </Col>
                        </Row>
                      </Col>

                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">冷却移动炮数量(门)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.f4}</span>
                          </Col>
                        </Row>
                      </Col>
                    </Row>
                  </div>
                </div>
              </Scrollbars>
            </TabPane>

            <TabPane tab="管网供水能力" key="4">
              <Scrollbars>
                <div style={{ height: '100%', padding: '0 15px' }}>
                  <div className="szzh-formula-calculate-content-css">
                    <div className="szzh-disaster-right-title-css">计算参数</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">供水管网直径</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <Input size="small" name="g1" onChange={this.onChangeValue} value={this.state.g1} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          mm
                        </span>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">管网内水流速</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue">
                        <RadioGroup name="g2" onChange={this.onChange4} value={this.state.g2}>
                          <Radio value={1}>支状管网1m/s</Radio>

                          <Radio value={1.5}>环状管网1.5m/s</Radio>
                        </RadioGroup>
                      </Col>
                    </Row>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={10} className="szzh-itemLabel">
                        <span className="szzh-span-css szzh-cal-small-fs ">消防车泵流量</span>
                      </Col>

                      <Col span={13} className="szzh-itemValue ">
                        <Input size="small" name="g3" onChange={this.onChangeValue} value={this.state.g3} />
                        <span style={{ marginLeft: '10px' }} className="szzh-cal-small-fs">
                          L/s
                        </span>
                      </Col>
                    </Row>
                  </div>

                  <div className="szzh-formula-calculate-divider-css" />

                  <div className="szzh-formula-calculate-button-css">
                    <Button size="small" onClick={this.onClickg}>
                      计算
                    </Button>

                    <Button size="small" className="szzh-buttonStyle" onClick={this.onReset8}>
                      重置
                    </Button>
                  </div>

                  <div className="szzh-formula-calculate-bottom-css">
                    <div className="szzh-disaster-right-title-css">计算结果</div>

                    <Row className="szzh-formula-calculate-row-css">
                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">管网供水流量(L/s)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.g4}</span>
                          </Col>
                        </Row>
                      </Col>

                      <Col span={12} className="szzh-resultWidth">
                        <Row>
                          <Col span={12} className="ant-col-custom szzh-itemLabel">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">停靠消防车数量(辆)</span>
                          </Col>

                          <Col span={12} className="ant-col-custom szzh-resultValue">
                            <span className="szzh-span-bottom-css szzh-cal-small-fs">{this.state.g5}</span>
                          </Col>
                        </Row>
                      </Col>
                    </Row>
                  </div>
                </div>
              </Scrollbars>
            </TabPane>
          </Tabs>
        </div>
      </Modal>
    );
  }
}

FormulaCalculate.propTypes = {};

export default FormulaCalculate;
